/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.EclipseClasspathConverter;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;

public class EclipseClasspathStorageProvider
implements ClasspathStorageProvider {
    public static final String DESCR = EclipseBundle.message("eclipse.classpath.storage.description", new Object[0]);

    @NonNls
    public String getID() {
        return "eclipse";
    }

    @Nls
    public String getDescription() {
        return DESCR;
    }

    public void assertCompatible(ModuleRootModel model) throws ConfigurationException {
        String moduleName = model.getModule().getName();
        for (OrderEntry entry : model.getOrderEntries()) {
            Library library;
            LibraryOrderEntry libraryEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (library = libraryEntry.getLibrary()) != null && libraryEntry.getRootUrls(OrderRootType.CLASSES).length == 1 && !library.isJarDirectory(library.getUrls(OrderRootType.CLASSES)[0])) continue;
            throw new ConfigurationException("Library '" + entry.getPresentableName() + "' from module '" + moduleName + "' dependencies is incompatible with eclipse format which supports only one library content root");
        }
        if (model.getContentRoots().length == 0) {
            throw new ConfigurationException("Module '" + moduleName + "' has no content roots thus is not compatible with eclipse format");
        }
        String output = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        String contentRoot = this.getContentRoot(model);
        if (output == null || !StringUtil.startsWith((CharSequence)VfsUtilCore.urlToPath((String)output), (CharSequence)contentRoot) && PathMacroManager.getInstance((ComponentManager)model.getModule()).collapsePath(output).equals(output)) {
            throw new ConfigurationException("Module '" + moduleName + "' output path is incompatible with eclipse format which supports output under content root only.\nPlease make sure that \"Inherit project compile output path\" is not selected");
        }
    }

    public void detach(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "detach"));
        }
        EclipseModuleManagerImpl.getInstance(module).setDocumentSet(null);
    }

    @NotNull
    public ClasspathStorageProvider.ClasspathConverter createConverter(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "createConverter"));
        }
        EclipseClasspathConverter eclipseClasspathConverter = new EclipseClasspathConverter(module);
        if (eclipseClasspathConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "createConverter"));
        }
        return eclipseClasspathConverter;
    }

    public String getContentRoot(@NotNull ModuleRootModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "getContentRoot"));
        }
        VirtualFile contentRoot = EPathUtil.getContentRoot(model);
        return contentRoot == null ? model.getContentRoots()[0].getPath() : contentRoot.getPath();
    }

    public void modulePathChanged(Module module, String path) {
        EclipseModuleManagerImpl moduleManager = EclipseModuleManagerImpl.getInstance(module);
        if (moduleManager != null) {
            moduleManager.setDocumentSet(null);
        }
    }

    @NotNull
    static CachedXmlDocumentSet getFileCache(@NotNull Module module) {
        CachedXmlDocumentSet fileCache;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "getFileCache"));
        }
        EclipseModuleManagerImpl moduleManager = EclipseModuleManagerImpl.getInstance(module);
        CachedXmlDocumentSet cachedXmlDocumentSet = fileCache = moduleManager != null ? moduleManager.getDocumentSet() : null;
        if (fileCache == null) {
            fileCache = new CachedXmlDocumentSet();
            if (moduleManager != null) {
                moduleManager.setDocumentSet(fileCache);
            }
            String storageRoot = ClasspathStorage.getStorageRootFromOptions((Module)module);
            fileCache.register(".classpath", storageRoot);
            fileCache.register(".project", storageRoot);
            fileCache.register("plugin.xml", storageRoot);
            fileCache.register(module.getName() + ".eml", ModuleUtilCore.getModuleDirPath((Module)module));
        }
        CachedXmlDocumentSet cachedXmlDocumentSet2 = fileCache;
        if (cachedXmlDocumentSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "getFileCache"));
        }
        return cachedXmlDocumentSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleRenamed(@NotNull Module module, @NotNull String oldName, @NotNull String newName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "moduleRenamed"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "moduleRenamed"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "moduleRenamed"));
        }
        try {
            VirtualFile source;
            CachedXmlDocumentSet fileSet = EclipseClasspathStorageProvider.getFileCache(module);
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(ModuleUtilCore.getModuleDirPath((Module)module));
            VirtualFile virtualFile = source = root == null ? null : root.findChild(oldName + ".eml");
            if (source != null && source.isValid()) {
                AccessToken token = WriteAction.start();
                try {
                    source.rename((Object)this, newName + ".eml");
                }
                finally {
                    token.finish();
                }
            }
            DotProjectFileHelper.saveDotProjectFile(module, fileSet.getParent(".project"));
            fileSet.unregister(oldName + ".eml");
            fileSet.register(newName + ".eml", ModuleUtilCore.getModuleDirPath((Module)module));
        }
        catch (IOException e) {
            EclipseClasspathWriter.LOG.warn((Throwable)e);
        }
    }
}

