/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.el.WebflowScopeImplicitVariable;
import com.intellij.spring.webflow.el.scopes.WebflowScope;
import com.intellij.spring.webflow.el.scopes.WebflowScopeProviderManager;
import com.intellij.spring.webflow.el.scopes.providers.WebflowScopeProvider;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class ELVariablesCollectorContext {
    private final WebflowModel myWebflowModel;
    private final XmlFile myFile;
    private final List<PsiVariable> myResultVars;
    @Nullable
    private final DomElement myDomElement;
    private Map<WebflowScope, List<JspImplicitVariable>> myScopeVarsMap;
    private final List<WebflowScopeProvider> myAcceptedProviders;

    ELVariablesCollectorContext(WebflowModel webflowModel, PsiElement host, List<PsiVariable> resultVars) {
        this.myWebflowModel = webflowModel;
        this.myFile = (XmlFile)host.getContainingFile().getOriginalFile();
        this.myResultVars = resultVars;
        this.myDomElement = DomUtil.getDomElement((PsiElement)host);
        this.myAcceptedProviders = new ArrayList<WebflowScopeProvider>();
        if (this.getDomElement() != null) {
            for (WebflowScopeProvider scopeProvider : WebflowScopeProviderManager.getService().getProviders()) {
                if (!scopeProvider.accept(this.getDomElement())) continue;
                this.myAcceptedProviders.add(scopeProvider);
            }
        }
    }

    XmlFile getFile() {
        return this.myFile;
    }

    WebflowModel getWebflowModel() {
        return this.myWebflowModel;
    }

    @Nullable
    DomElement getDomElement() {
        return this.myDomElement;
    }

    Project getProject() {
        return this.myFile.getProject();
    }

    List<WebflowScopeProvider> getAcceptedProviders() {
        return this.myAcceptedProviders;
    }

    void addScopeVariable(WebflowScope webflowScope, ELImplicitVariable implicitVariable) {
        this.myResultVars.add((PsiVariable)implicitVariable);
        Map<WebflowScope, List<JspImplicitVariable>> scopeVars = this.getScopeVariablesMap();
        if (!scopeVars.containsKey((Object)webflowScope)) {
            scopeVars.put(webflowScope, (List<JspImplicitVariable>)new SmartList());
        }
        scopeVars.get((Object)webflowScope).add((JspImplicitVariable)implicitVariable);
    }

    void processScopeVariables() {
        Map<WebflowScope, List<JspImplicitVariable>> scopeVars = this.getScopeVariablesMap();
        for (WebflowScope webflowScope : scopeVars.keySet()) {
            Factory factory = () -> (List)scopeVars.get((Object)webflowScope);
            this.myResultVars.add((PsiVariable)new WebflowScopeImplicitVariable(webflowScope, (PsiElement)new FakePsiElement(){

                public PsiElement getParent() {
                    return ELVariablesCollectorContext.this.getFile();
                }
            }, (Factory<List<JspImplicitVariable>>)factory));
        }
    }

    @Nullable
    private Module getModule() {
        Module module = this.getWebflowModel().getFlow().getModule();
        return module != null ? module : ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myFile);
    }

    private Map<WebflowScope, List<JspImplicitVariable>> getScopeVariablesMap() {
        if (this.myScopeVarsMap == null) {
            this.myScopeVarsMap = new EnumMap<WebflowScope, List<JspImplicitVariable>>(WebflowScope.class);
            Module module = this.getModule();
            if (module != null) {
                for (WebflowScopeProvider provider : WebflowScopeProviderManager.getService().getAvailableProviders(this.getDomElement())) {
                    this.myScopeVarsMap.put(provider.getScope(), (List<JspImplicitVariable>)new SmartList());
                }
            }
        }
        return this.myScopeVarsMap;
    }
}

