/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSProvider;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OSVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.util.CloudConfigurableBase;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyChecker;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OSCloudConfigurable
extends CloudConfigurableBase<OSCloudConfiguration> {
    private static final String OS3_PROVIDER_URL = "https://localhost:8443";
    private DelayedRunner myRunner;
    protected JTextField myEmailTextField;
    protected JPasswordField myPasswordField;
    protected JPanel myMainPanel;
    private HyperlinkLabel myUploadSshKeyHyperlinkLabel;
    private ComboBox myDomainComboBox;
    private ComboBox myLibraServerComboBox;
    private JComboBox myVersionComboBox;
    private JBLabel myDomainLabel;
    private OSCloudConfiguration myCoreConfiguration;
    private final List<VersionItem> myVersionItems;

    public OSCloudConfigurable(OSCloudConfiguration configuration) {
        super((ServerType)OSCloudType.getInstance(), (CloudConfigurationBase)configuration);
        this.$$$setupUI$$$();
        new SshKeyChecker().setupUploadLabel(this.myUploadSshKeyHyperlinkLabel, (UnnamedConfigurable)this, (ServerConfiguration)configuration, this.getCloudType());
        this.myVersionItems = new ArrayList<VersionItem>();
        for (OSVersion version : OSVersion.values()) {
            VersionItem item = new VersionItem(version);
            this.myVersionItems.add(item);
            this.myVersionComboBox.addItem(item);
        }
        this.myVersionComboBox.addActionListener(e -> this.onVersionChanged());
        this.fillServerUrls();
        this.initConnectionData();
    }

    private void fillServerUrls() {
        this.myLibraServerComboBox.removeAllItems();
        if (this.isOS3()) {
            this.myLibraServerComboBox.addItem((Object)OS3_PROVIDER_URL);
        } else {
            for (OSProvider provider : OSProvider.values()) {
                this.myLibraServerComboBox.addItem((Object)provider);
            }
        }
    }

    private void initConnectionData() {
        this.myEmailTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                OSCloudConfigurable.this.myDomainComboBox.removeAllItems();
            }
        });
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                OSCloudConfigurable.this.myDomainComboBox.removeAllItems();
            }
        });
        this.myRunner = new DelayedRunner(this.myMainPanel){

            protected boolean wasChanged() {
                OSCloudConfiguration configuration = new OSCloudConfiguration();
                try {
                    OSCloudConfigurable.this.applyCoreTo(configuration);
                }
                catch (ConfigurationException e) {
                    return true;
                }
                if (OSCloudConfigurable.this.myCoreConfiguration != null && OSCloudConfigurable.this.isCoreConfigEqual(OSCloudConfigurable.this.myCoreConfiguration, configuration)) {
                    return false;
                }
                OSCloudConfigurable.this.myCoreConfiguration = configuration;
                return true;
            }

            protected void run() {
                if (OSCloudConfigurable.this.isOS3()) {
                    return;
                }
                OSCloudConfigurable.this.loadDomains();
            }
        };
    }

    private boolean isOS3() {
        return ((VersionItem)this.myVersionComboBox.getSelectedItem()).getVersion() == OSVersion.OS3;
    }

    private void onVersionChanged() {
        boolean isVersion3 = this.isOS3();
        this.fillServerUrls();
        this.myDomainLabel.setVisible(!isVersion3);
        this.myDomainComboBox.setVisible(!isVersion3);
        this.myUploadSshKeyHyperlinkLabel.setVisible(!isVersion3);
    }

    private void loadDomains() {
        RemoteServer tempServer = this.createTempServer();
        if (tempServer == null) {
            return;
        }
        new CloudConnectionTask<String[], OSCloudConfiguration, OSDeploymentConfiguration, OSServerRuntimeInstance>(null, "Loading domains", tempServer){

            protected String[] run(OSServerRuntimeInstance serverRuntime) throws ServerRuntimeException {
                return serverRuntime.getAvailableDomains();
            }

            protected void postPerform(String[] domains) {
                OSCloudConfigurable.this.myDomainComboBox.removeAllItems();
                for (String domain : domains) {
                    OSCloudConfigurable.this.myDomainComboBox.addItem((Object)domain);
                }
            }
        }.performAsync();
    }

    public boolean isModified() {
        OSCloudConfiguration configuration = new OSCloudConfiguration();
        try {
            this.applyTo(configuration);
        }
        catch (ConfigurationException e) {
            return true;
        }
        return !this.isConfigEqual((OSCloudConfiguration)this.myConfiguration, configuration);
    }

    private boolean isConfigEqual(OSCloudConfiguration configuration1, OSCloudConfiguration configuration2) {
        return this.isCoreConfigEqual(configuration1, configuration2) && Comparing.equal((String)configuration1.getDomain(), (String)configuration2.getDomain());
    }

    protected boolean isCoreConfigEqual(OSCloudConfiguration configuration1, OSCloudConfiguration configuration2) {
        return super.isCoreConfigEqual((CloudConfigurationBase)configuration1, (CloudConfigurationBase)configuration2) && Comparing.equal((String)configuration1.getLibraServer(), (String)configuration2.getLibraServer()) && Comparing.equal((Object)((Object)configuration1.getVersion()), (Object)((Object)configuration2.getVersion()));
    }

    public void apply() throws ConfigurationException {
        this.applyTo((OSCloudConfiguration)this.myConfiguration);
    }

    private void applyTo(OSCloudConfiguration configuration) throws ConfigurationException {
        String domain;
        OSCloudConfiguration validationCoreConfig = new OSCloudConfiguration();
        this.applyCoreTo(validationCoreConfig);
        Object selectedDomain = this.myDomainComboBox.getEditor().getItem();
        String string = domain = selectedDomain != null ? (String)selectedDomain : "";
        if (!this.isOS3() && StringUtil.isEmpty((String)domain)) {
            throw new RuntimeConfigurationError("Domain required");
        }
        this.applyCoreTo(configuration);
        configuration.setDomain(domain);
    }

    protected void applyCoreTo(OSCloudConfiguration configuration) throws ConfigurationException {
        Object provider = this.myLibraServerComboBox.getEditor().getItem();
        String apiUrl = provider instanceof OSProvider ? ((OSProvider)((Object)provider)).getApiUrl() : (String)provider;
        if (StringUtil.isEmpty((String)apiUrl)) {
            throw new RuntimeConfigurationError("Server (API URL) required");
        }
        super.applyCoreTo((CloudConfigurationBase)configuration);
        configuration.setVersion(((VersionItem)this.myVersionComboBox.getSelectedItem()).getVersion());
        configuration.setLibraServer(apiUrl);
        configuration.setDomain("");
    }

    public void reset() {
        super.reset();
        this.myVersionComboBox.setSelectedItem(ContainerUtil.find(this.myVersionItems, item -> item.getVersion() == ((OSCloudConfiguration)this.myConfiguration).getVersion()));
        this.myDomainComboBox.setSelectedItem((Object)((OSCloudConfiguration)this.myConfiguration).getDomain());
        OSProvider provider = ((OSCloudConfiguration)this.myConfiguration).getProvider();
        this.myLibraServerComboBox.setSelectedItem(provider == null ? ((OSCloudConfiguration)this.myConfiguration).getLibraServer() : provider);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myRunner);
    }

    protected JComponent getMainPanel() {
        return this.myMainPanel;
    }

    protected JTextField getEmailTextField() {
        return this.myEmailTextField;
    }

    protected JPasswordField getPasswordField() {
        return this.myPasswordField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        ComboBox comboBox;
        ComboBox comboBox2;
        HyperlinkLabel hyperlinkLabel;
        JPasswordField jPasswordField;
        JTextField jTextField;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Username(email):");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Password:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDomainLabel = jBLabel = new JBLabel();
        jBLabel.setText("Domain:");
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEmailTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUploadSshKeyHyperlinkLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myDomainComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel.add((Component)comboBox2, new GridConstraints(4, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Server (API URL):");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibraServerComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Version:");
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class VersionItem {
        private final OSVersion myVersion;

        public VersionItem(OSVersion version) {
            this.myVersion = version;
        }

        public OSVersion getVersion() {
            return this.myVersion;
        }

        public String toString() {
            return this.myVersion.getName();
        }
    }
}

