/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspSuppressionProvider
extends DefaultXmlSuppressionProvider {
    @Nullable
    private static PsiElement getAnchor(PsiElement originalElement) {
        ELExpressionHolder holder;
        BaseJspFile file = BaseJspUtil.getJspFile(originalElement);
        if (file == null) {
            return null;
        }
        if (originalElement instanceof OuterLanguageElement && (holder = (ELExpressionHolder)PsiTreeUtil.getParentOfType((PsiElement)originalElement, ELExpressionHolder.class, (boolean)false)) != null) {
            return PsiTreeUtil.getPrevSiblingOfType((PsiElement)(holder.getParent() instanceof XmlTag ? holder : PsiTreeUtil.getParentOfType((PsiElement)holder, XmlTag.class)), XmlText.class);
        }
        JspxFileViewProvider viewProvider = file.getViewProvider();
        PsiElement element = viewProvider.findElementAt(originalElement.getTextOffset(), viewProvider.getBaseLanguage());
        return PsiTreeUtil.getContextOfType((PsiElement)element, XmlText.class, (boolean)false);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/JspSuppressionProvider", "isSuppressedFor"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/JspSuppressionProvider", "isSuppressedFor"));
        }
        PsiElement anchor = JspSuppressionProvider.getAnchor(element);
        if (anchor != null) {
            return this.findSuppression(anchor, inspectionId, element) != null;
        }
        return this.findFileSuppression(null, inspectionId, element) != null;
    }

    protected PsiElement findSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiElement element = this.findSuppressionLeaf(anchor, id, JspSuppressionProvider.getTopmostOffset(originalElement));
        if (element != null) {
            return element;
        }
        return this.findFileSuppression(anchor, id, originalElement);
    }

    protected PsiElement findFileSuppression(PsiElement anchor, String id, PsiElement originalElement) {
        PsiElement leaf;
        BaseJspFile file = BaseJspUtil.getJspFile(anchor == null ? originalElement : anchor);
        if (file == null) {
            return null;
        }
        XmlTag rootTag = file.getRootTag();
        int offset = JspSuppressionProvider.getFileHeaderOffset(originalElement);
        for (leaf = rootTag.getLastChild(); leaf != null && leaf.getTextOffset() > offset; leaf = leaf.getPrevSibling()) {
        }
        return this.findSuppressionLeaf(leaf, id, 0);
    }

    private static int getFileHeaderOffset(PsiElement originalElement) {
        XmlTag originalRootTag;
        XmlDocument originalDocument;
        PsiFile originalFile = originalElement.getContainingFile();
        if (originalFile instanceof XmlFile && (originalDocument = ((XmlFile)originalFile).getDocument()) != null && (originalRootTag = originalDocument.getRootTag()) != null) {
            return originalRootTag.getTextOffset();
        }
        return 0;
    }

    private static int getTopmostOffset(PsiElement originalElement) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (tag != null) {
            XmlTag prevSibling = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)tag, XmlTag.class);
            if (prevSibling == null) {
                XmlTag parentTag = tag.getParentTag();
                if (parentTag != null) {
                    return parentTag.getTextOffset();
                }
            } else {
                return prevSibling.getTextOffset();
            }
        }
        return 0;
    }

    public void suppressForFile(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/JspSuppressionProvider", "suppressForFile"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/JspSuppressionProvider", "suppressForFile"));
        }
        BaseJspFile file = BaseJspUtil.getJspFile(element);
        assert (file != null);
        XmlTag rootTag = file.getRootTag();
        PsiElement suppression = this.findFileSuppression((PsiElement)rootTag, inspectionId, element);
        this.suppress((PsiFile)file, suppression, inspectionId, rootTag.getTextRange().getStartOffset());
    }

    public void suppressForTag(@NotNull PsiElement element, @NotNull String inspectionId) {
        int offset;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/JspSuppressionProvider", "suppressForTag"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/codeInspection/JspSuppressionProvider", "suppressForTag"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        assert (tag != null);
        PsiFile file = element.getContainingFile();
        String text = file.getText();
        for (offset = tag.getTextRange().getStartOffset(); offset > 0 && text.charAt(offset - 1) != '\n'; --offset) {
        }
        this.suppress(file, this.findSuppressionLeaf(JspSuppressionProvider.getAnchor(element), null, JspSuppressionProvider.getTopmostOffset(element)), inspectionId, offset);
    }

    protected String getPrefix() {
        return "<%--suppress ";
    }

    protected String getSuffix() {
        return " --%>";
    }
}

