/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lang.xml.XmlFoldingBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.jspXml.JspDeclaration;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JspFoldingBuilder
extends XmlFoldingBuilder {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        XmlDocument xmlDocument;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/jsp/JspFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/jsp/JspFoldingBuilder", "buildFoldRegions"));
        }
        PsiElement psiElement = node.getPsi();
        Object[] foldingDescriptors = super.buildFoldRegions(node, document);
        if (psiElement instanceof PsiFile && BaseJspUtil.getJspFile(psiElement).getFileType() == NewJspLanguage.INSTANCE && (xmlDocument = HtmlUtil.getRealXmlDocument((XmlDocument)((XmlFile)psiElement).getDocument())) != null) {
            Object[] additionalFoldingDescriptors = super.buildFoldRegions(xmlDocument.getNode(), document);
            FoldingDescriptor[] foldingDescriptorArray = (FoldingDescriptor[])ArrayUtil.mergeArrays((Object[])foldingDescriptors, (Object[])additionalFoldingDescriptors);
            if (foldingDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFoldingBuilder", "buildFoldRegions"));
            }
            return foldingDescriptorArray;
        }
        if (foldingDescriptors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptors;
    }

    protected int getCommentStartEnd(XmlComment element) {
        PsiElement firstChild = element.getFirstChild();
        if (firstChild instanceof XmlToken && ((XmlToken)firstChild).getTokenType() == JspTokenType.JSP_COMMENT) {
            return 4;
        }
        return super.getCommentStartEnd(element);
    }

    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof JspScriptlet || element instanceof JspDeclaration) {
            ASTNode tagNode = element.getNode();
            if (tagNode.getFirstChildNode() != tagNode.getLastChildNode()) {
                return new TextRange(tagNode.getFirstChildNode().getTextRange().getEndOffset(), tagNode.getLastChildNode().getTextRange().getStartOffset());
            }
            return null;
        }
        if (!(element instanceof XmlComment) || !(element instanceof XmlToken)) {
            return super.getRangeToFold(element);
        }
        return null;
    }

    protected void addElementsToFold(List<FoldingDescriptor> foldings, XmlElement tag, Document document) {
        if (this.addToFold(foldings, (PsiElement)tag, document) || tag instanceof JspXmlRootTag) {
            this.doAddForChildren(tag, foldings, document);
        }
    }
}

