/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.jsp;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.JspHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.parsing.jsp.EscapedJavaLexer;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JspJavaLexer
extends Lexer {
    private final JspHighlightingLexer myJspLexer = new JspHighlightingLexer();
    private final Lexer myJavaLexer;
    private final EscapedJavaLexer myEscapedJavaLexer;
    private Lexer myCurJavaLexer = null;

    public JspJavaLexer(JspFile file, LanguageLevel languageLevel) {
        this.myJavaLexer = JavaParserDefinition.createLexer((LanguageLevel)languageLevel);
        this.myEscapedJavaLexer = new EscapedJavaLexer('\"', languageLevel);
        this.myJspLexer.setFile((BaseJspFile)file);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/parsing/jsp/JspJavaLexer", "start"));
        }
        this.myJspLexer.start(buffer, startOffset, endOffset, initialState);
        this.setupJavaLexer();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myJspLexer.getBufferSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/jsp/JspJavaLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getState() {
        return this.myJspLexer.getState();
    }

    public IElementType getTokenType() {
        IElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == BaseJspElementType.JSP_SCRIPTLET || tokenType == BaseJspElementType.JSP_EXPRESSION || tokenType == BaseJspElementType.JSP_DECLARATION) {
            return this.myCurJavaLexer.getTokenType();
        }
        return tokenType;
    }

    public int getTokenStart() {
        IElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == BaseJspElementType.JSP_SCRIPTLET || tokenType == BaseJspElementType.JSP_EXPRESSION || tokenType == BaseJspElementType.JSP_DECLARATION) {
            return this.myCurJavaLexer.getTokenStart();
        }
        return this.myJspLexer.getTokenStart();
    }

    public int getTokenEnd() {
        IElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == BaseJspElementType.JSP_SCRIPTLET || tokenType == BaseJspElementType.JSP_EXPRESSION || tokenType == BaseJspElementType.JSP_DECLARATION) {
            return this.myCurJavaLexer.getTokenEnd();
        }
        return this.myJspLexer.getTokenEnd();
    }

    public void advance() {
        IElementType tokenType = this.myJspLexer.getTokenType();
        if (tokenType == BaseJspElementType.JSP_SCRIPTLET || tokenType == BaseJspElementType.JSP_EXPRESSION || tokenType == BaseJspElementType.JSP_DECLARATION) {
            this.myCurJavaLexer.advance();
            if (this.myCurJavaLexer.getTokenType() != null) {
                return;
            }
        }
        this.myJspLexer.advance();
        this.setupJavaLexer();
    }

    private void setupJavaLexer() {
        while (true) {
            IElementType tokenType;
            if ((tokenType = this.myJspLexer.getTokenType()) == BaseJspElementType.JSP_EXPRESSION) {
                if (this.myJspLexer.isInsideDQAttributeValue()) {
                    this.myEscapedJavaLexer.setSurroundingQuote('\"');
                    this.myCurJavaLexer = this.myEscapedJavaLexer;
                } else if (this.myJspLexer.isInsideSQAttributeValue()) {
                    this.myEscapedJavaLexer.setSurroundingQuote('\'');
                    this.myCurJavaLexer = this.myEscapedJavaLexer;
                } else {
                    this.myCurJavaLexer = this.myJavaLexer;
                }
            } else if (tokenType == BaseJspElementType.JSP_SCRIPTLET || tokenType == BaseJspElementType.JSP_DECLARATION) {
                this.myCurJavaLexer = this.myJavaLexer;
            } else {
                return;
            }
            this.myCurJavaLexer.start(this.myJspLexer.getBufferSequence(), this.myJspLexer.getTokenStart(), this.myJspLexer.getTokenEnd());
            if (this.myCurJavaLexer.getTokenType() != null) {
                return;
            }
            this.myJspLexer.advance();
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        Position position = new Position(this.myCurJavaLexer != null ? this.myCurJavaLexer.getCurrentPosition() : null, this.myJspLexer.getCurrentPosition());
        if (position == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/jsp/JspJavaLexer", "getCurrentPosition"));
        }
        return position;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/parsing/jsp/JspJavaLexer", "restore"));
        }
        Position p = (Position)position;
        this.myJspLexer.restore(p.getJspPosition());
        LexerPosition javaPos = p.getJavaPosition();
        if (javaPos != null && javaPos.getOffset() < this.myCurJavaLexer.getBufferEnd()) {
            this.myCurJavaLexer.restore(javaPos);
        } else {
            this.myCurJavaLexer = null;
            this.setupJavaLexer();
        }
    }

    public int getBufferEnd() {
        return this.myJspLexer.getBufferEnd();
    }

    private static class Position
    implements LexerPosition {
        private final LexerPosition myJavaPosition;
        private final LexerPosition myJspPosition;

        public Position(LexerPosition javaPosition, LexerPosition jspPosition) {
            this.myJavaPosition = javaPosition;
            this.myJspPosition = jspPosition;
        }

        public int getOffset() {
            return Math.max(this.myJspPosition.getOffset(), this.myJavaPosition.getOffset());
        }

        public LexerPosition getJavaPosition() {
            return this.myJavaPosition;
        }

        public LexerPosition getJspPosition() {
            return this.myJspPosition;
        }

        public int getState() {
            throw new UnsupportedOperationException("Method getState is not yet implemented in " + this.getClass().getName());
        }
    }
}

