/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlText;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CharTable;
import com.intellij.util.Processor;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseJspUtil {
    @NonNls
    private static final String PAGE_DIRECTIVE = "page";
    @NonNls
    private static final String TAG_DIRECTIVE = "tag";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String TAGLIB = "taglib";
    @NonNls
    private static final String ATTRIBUTE = "attribute";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String DIRECTIVE_PREFIX = "directive.";
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.JspManagerImpl");
    @NonNls
    public static final String PATH_TO_STANDARD_SCHEMAS = "/standardSchemas/";

    @Nullable
    public static JspDirectiveKind getDirectiveKindByTag(XmlTag tag) {
        String name = tag.getLocalName();
        if (!(tag instanceof JspDirective || name.startsWith(DIRECTIVE_PREFIX) && "http://java.sun.com/JSP/Page".equals(tag.getNamespace()))) {
            return null;
        }
        return BaseJspUtil.getDirectiveKindByName(name);
    }

    @Nullable
    public static JspDirectiveKind getDirectiveKindByName(String name) {
        if (PAGE_DIRECTIVE.equals(name = StringUtil.trimStart((String)name, (String)DIRECTIVE_PREFIX)) || TAG_DIRECTIVE.equals(name)) {
            return JspDirectiveKind.PAGE;
        }
        if (INCLUDE.equals(name)) {
            return JspDirectiveKind.INCLUDE;
        }
        if (TAGLIB.equals(name)) {
            return JspDirectiveKind.TAGLIB;
        }
        if (ATTRIBUTE.equals(name)) {
            return JspDirectiveKind.ATTRIBUTE;
        }
        if (VARIABLE.equals(name)) {
            return JspDirectiveKind.VARIABLE;
        }
        return null;
    }

    public static String getDirectiveAttributeName(JspDirectiveKind directiveKind, BaseJspFile file) {
        if (directiveKind == JspDirectiveKind.PAGE) {
            return file.isTagPage() ? "directive.tag" : "directive.page";
        }
        return DIRECTIVE_PREFIX + directiveKind.name().toLowerCase();
    }

    public static ASTNode parseSimpleJspBlock(@NotNull IElementType rootType, CharSequence text, CharTable table, @NotNull IElementType start, @NotNull IElementType end, int startLength) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/psi/jsp/BaseJspUtil", "parseSimpleJspBlock"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/psi/jsp/BaseJspUtil", "parseSimpleJspBlock"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/psi/jsp/BaseJspUtil", "parseSimpleJspBlock"));
        }
        CompositeElement treeElement = ASTFactory.composite((IElementType)rootType);
        treeElement.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)start, (CharSequence)table.intern(text, 0, Math.min(startLength, text.length()))));
        if (text.length() > startLength + 1 && text.charAt(text.length() - 1) == '>' && text.charAt(text.length() - 2) == '%') {
            JspXmlText jspXmlText = new JspXmlText();
            treeElement.rawAddChildren((TreeElement)jspXmlText);
            if (text.length() > startLength + 2) {
                jspXmlText.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JspTokenType.JAVA_CODE, (CharSequence)table.intern(text, startLength, text.length() - 2)));
            }
            treeElement.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)end, (CharSequence)table.intern(text, text.length() - 2, text.length())));
        } else if (text.length() > 2) {
            JspXmlText jspXmlText = new JspXmlText();
            treeElement.rawAddChildren((TreeElement)jspXmlText);
            jspXmlText.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JspTokenType.JAVA_CODE, (CharSequence)table.intern(text, startLength, text.length())));
        }
        return treeElement;
    }

    @NotNull
    public static XmlFile getResource(@NonNls String resourceName, @NotNull Project project, @NotNull Class baseClass) {
        VirtualFile fileByURL;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/jsp/BaseJspUtil", "getResource"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/jsp/BaseJspUtil", "getResource"));
        }
        URL resource = baseClass.getResource(PATH_TO_STANDARD_SCHEMAS + resourceName);
        if (resource == null) {
            LOG.error("Can't load resource: " + resourceName);
        }
        if ((fileByURL = VfsUtil.findFileByURL((URL)resource)) == null) {
            LOG.error("Can't find file by resource: " + resource);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(fileByURL);
        assert (psiFile instanceof XmlFile) : "Can't load resource: " + resourceName;
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/jsp/BaseJspUtil", "getResource"));
        }
        return xmlFile;
    }

    public static <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T baseJspFile, Processor<T> processor) {
        processor.process(baseJspFile);
    }

    @Nullable
    public static BaseJspFile getJspFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/jsp/BaseJspUtil", "getJspFile"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        if (psi instanceof BaseJspFile) {
            return (BaseJspFile)psi;
        }
        return null;
    }

    public static boolean isInJspFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/jsp/BaseJspUtil", "isInJspFile"));
        }
        return BaseJspUtil.getJspFile((PsiElement)psiFile) != null;
    }

    public static PsiReference[] getReferencesByElement(PsiElement element, boolean _soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed) {
        boolean soft = _soft || PsiTreeUtil.getChildOfType((PsiElement)element, ELExpressionHolder.class) != null || PsiTreeUtil.getChildOfType((PsiElement)element, JspXmlTagBase.class) != null;
        return PathReferenceManager.getInstance().createReferences(element, soft, endingSlashNotAllowed, relativePathsAllowed, new PathReferenceProvider[0]);
    }
}

