/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ProjectBasedConnectionOwner;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionOwnerFactory {
    public static ConnectionOwner createConnectionOwner(final @Nullable Project project) {
        return new ProjectBasedConnectionOwner(project){

            protected void showMessageImpl(@NotNull String message, @NotNull String title, @Nullable WebServerConfig config, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/plugins/remotesdk/ConnectionOwnerFactory$1", "showMessageImpl"));
                }
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/ConnectionOwnerFactory$1", "showMessageImpl"));
                }
                Messages.showDialog((Project)project, (String)message, (String)message, (String[])new String[]{Messages.OK_BUTTON}, (int)0, (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption);
            }
        };
    }

    public static ConnectionOwner createConnectionOwner(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/ConnectionOwnerFactory", "createConnectionOwner"));
        }
        return com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory.createConnectionOwner((Component)component);
    }

    public static ConnectionOwner createConnectionOwner(@Nullable Project project, @Nullable Component component) {
        if (project != null || component == null) {
            return ConnectionOwnerFactory.createConnectionOwner(project);
        }
        return ConnectionOwnerFactory.createConnectionOwner(component);
    }

    @Deprecated
    public static ConnectionOwner createConnectionOwner(@Nullable Object projectOrComponent) {
        if (projectOrComponent == null || projectOrComponent instanceof Project) {
            return ConnectionOwnerFactory.createConnectionOwner((Project)projectOrComponent);
        }
        if (projectOrComponent instanceof Component) {
            return ConnectionOwnerFactory.createConnectionOwner((Component)projectOrComponent);
        }
        throw new IllegalArgumentException("Unexpected type of connection owner (" + projectOrComponent.getClass().getName() + ")");
    }
}

