/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.formatter;

import com.intellij.coldFusion.model.formatter.CfmlFormatterUtil;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class CfmlWrappingProcessor
extends CfmlFormatterUtil {
    private final CommonCodeStyleSettings mySettings;
    private ASTNode myNode;

    CfmlWrappingProcessor(ASTNode node, CommonCodeStyleSettings settings) {
        this.myNode = node;
        this.mySettings = settings;
    }

    Wrap createChildWrap(ASTNode child, Wrap defaultWrap, Wrap childWrap) {
        ASTNode superParent;
        IElementType childType = child.getElementType();
        IElementType parentType = this.myNode.getElementType();
        if (childType == CfscriptTokenTypes.COMMA || childType == CfscriptTokenTypes.SEMICOLON) {
            return defaultWrap;
        }
        if ((parentType == CfmlElementTypes.PARAMETERS_LIST || parentType == CfmlElementTypes.ARGUMENT_LIST) && (superParent = this.myNode.getTreeParent()) != null) {
            if (superParent.getElementType() == CfmlElementTypes.FUNCTION_CALL_EXPRESSION && this.mySettings.CALL_PARAMETERS_WRAP != 0) {
                if (this.myNode.getFirstChildNode() == child) {
                    if (this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE) {
                        return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                    }
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                if (!this.mySettings.PREFER_PARAMETERS_WRAP && childWrap != null) {
                    return Wrap.createChildWrap((Wrap)childWrap, (WrapType)WrappingUtil.getWrapType((int)this.mySettings.CALL_PARAMETERS_WRAP), (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.CALL_PARAMETERS_WRAP), (boolean)true);
            }
            if (superParent.getElementType() == CfmlElementTypes.FUNCTION_DEFINITION && this.mySettings.METHOD_PARAMETERS_WRAP != 0) {
                if (this.myNode.getFirstChildNode() == child) {
                    if (this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE) {
                        return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                    }
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.METHOD_PARAMETERS_WRAP), (boolean)true);
            }
        }
        if (parentType == CfmlElementTypes.FUNCTION_CALL_EXPRESSION && this.mySettings.CALL_PARAMETERS_WRAP != 0 && childType == CfscriptTokenTypes.R_BRACKET) {
            return Wrap.createWrap((WrapType)(this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE ? WrapType.NORMAL : WrapType.NONE), (boolean)true);
        }
        if (parentType == CfmlElementTypes.FOREXPRESSION && this.mySettings.FOR_STATEMENT_WRAP != 0) {
            return CfmlWrappingProcessor.createChildWrap(child, this.mySettings.FOR_STATEMENT_WRAP, this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE);
        }
        if (parentType == CfmlElementTypes.IFEXPRESSION && childType == CfscriptTokenTypes.ELSE_KEYWORD) {
            return Wrap.createWrap((WrapType)(this.mySettings.ELSE_ON_NEW_LINE ? WrapType.NORMAL : WrapType.NONE), (boolean)true);
        }
        if (this.mySettings.BINARY_OPERATION_WRAP != 0 && CfmlElementTypes.BINARY_EXPRESSION == parentType && (this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE && CfmlFormatterUtil.isBinaryOperator(childType) || !this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE && this.isRightOperand(child))) {
            return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.BINARY_OPERATION_WRAP), (boolean)true);
        }
        if (this.mySettings.ASSIGNMENT_WRAP != 0 && parentType == CfmlElementTypes.ASSIGNMENT) {
            if (!CfmlFormatterUtil.isAssignmentOperator(childType)) {
                if (FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)CfmlFormatterUtil.ASSIGNMENT_OPERATORS) && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.ASSIGNMENT_WRAP), (boolean)true);
            }
            if (this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        }
        if (parentType == CfmlElementTypes.TERNARY_EXPRESSION) {
            if (this.myNode.getFirstChildNode() != child && (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE ? !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)CfscriptTokenTypes.QUESTION) && !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)CfscriptTokenTypes.DOTDOT) : childType != CfscriptTokenTypes.QUESTION && childType != CfscriptTokenTypes.DOTDOT)) {
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.mySettings.TERNARY_OPERATION_WRAP), (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        return defaultWrap;
    }

    private boolean isRightOperand(ASTNode child) {
        ASTNode secondExpression = this.myNode.findChildByType(CfmlElementTypes.EXPRESSIONS, this.myNode.findChildByType(CfmlFormatterUtil.BINARY_OPERATORS));
        return child == secondExpression;
    }

    private static Wrap createChildWrap(ASTNode child, int parentWrap, boolean newLineAfterLBrace, boolean newLineBeforeRBrace) {
        IElementType childType = child.getElementType();
        if (childType != CfscriptTokenTypes.L_BRACKET && childType != CfscriptTokenTypes.R_BRACKET) {
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)CfscriptTokenTypes.L_BRACKET)) {
                if (newLineAfterLBrace) {
                    return Wrap.createChildWrap((Wrap)Wrap.createWrap((int)parentWrap, (boolean)true), (WrapType)WrapType.ALWAYS, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)parentWrap), (boolean)true);
        }
        if (childType == CfscriptTokenTypes.R_BRACKET && newLineBeforeRBrace) {
            return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
        }
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
    }
}

