/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlProperty;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlRecursiveElementVisitor;
import com.intellij.coldFusion.model.psi.CfmlSuperComponentReference;
import com.intellij.coldFusion.model.psi.impl.CfmlTagImpl;
import com.intellij.coldFusion.model.psi.impl.CfmlTagScriptImpl;
import com.intellij.coldFusion.model.psi.stubs.CfmlStubElementTypes;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlTagComponentImpl
extends CfmlTagImpl
implements CfmlComponent,
StubBasedPsiElement<NamedStub> {
    public CfmlTagComponentImpl(ASTNode astNode) {
        super(astNode);
    }

    public CfmlTagComponentImpl(@NotNull NamedStub<CfmlComponent> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "<init>"));
        }
        super(stub, CfmlStubElementTypes.COMPONENT_TAG);
    }

    @Override
    public String getName() {
        String name = CfmlPsiUtil.getPureAttributeValue(this, "name");
        String nameFromFile = CfmlUtil.getFileName(this);
        return !StringUtil.isEmpty((String)nameFromFile) ? nameFromFile : (name != null ? name : "");
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "setName"));
        }
        return null;
    }

    @Override
    @NotNull
    public CfmlFunction[] getFunctions() {
        Object[] functions = (CfmlFunction[])this.findChildrenByClass(CfmlFunction.class);
        CfmlTagScriptImpl[] tagScripts = (CfmlTagScriptImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)this, CfmlTagScriptImpl.class);
        if (tagScripts != null) {
            for (CfmlTagScriptImpl tagScript : tagScripts) {
                Object[] functionsFromScript = (CfmlFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)tagScript, CfmlFunction.class);
                if (functionsFromScript == null) continue;
                functions = (CfmlFunction[])ArrayUtil.mergeArrays((Object[])functions, (Object[])functionsFromScript);
            }
        }
        if (functions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getFunctions"));
        }
        return functions;
    }

    @Override
    @NotNull
    public CfmlFunction[] getFunctionsWithSupers(boolean isSuperPriority) {
        CfmlFunction[] cfmlFunctionArray = CfmlPsiUtil.getFunctionsWithSupers(this, isSuperPriority);
        if (cfmlFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getFunctionsWithSupers"));
        }
        return cfmlFunctionArray;
    }

    @Override
    @NotNull
    public CfmlProperty[] getProperties() {
        CfmlProperty[] cfmlPropertyArray = (CfmlProperty[])this.findChildrenByClass(CfmlProperty.class);
        if (cfmlPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getProperties"));
        }
        return cfmlPropertyArray;
    }

    @Override
    @NotNull
    public CfmlProperty[] getPropertiesWithSupers(boolean isSuperPriority) {
        CfmlProperty[] cfmlPropertyArray = CfmlPsiUtil.getPropertiesWithSupers(this, isSuperPriority);
        if (cfmlPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getPropertiesWithSupers"));
        }
        return cfmlPropertyArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        CfmlProperty[] propertiesWithSupers;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "processDeclarations"));
        }
        if (!(lastParent != null && lastParent.getParent() == this || CfmlPsiUtil.processDeclarations(processor, state, null, this))) {
            return false;
        }
        for (CfmlFunction function : this.getFunctionsWithSupers(place.getFirstChild() instanceof CfmlSuperComponentReference)) {
            if (processor.execute((PsiElement)function, state)) continue;
            return false;
        }
        for (CfmlProperty property : propertiesWithSupers = this.getPropertiesWithSupers(place.getFirstChild() instanceof CfmlSuperComponentReference)) {
            if (processor.execute((PsiElement)property, state)) continue;
            return false;
        }
        return CfmlPsiUtil.processGlobalVariablesForComponent(this, processor, state, lastParent);
    }

    @Override
    @NotNull
    public String getTagName() {
        PsiElement childByType = this.findChildByType(CfmlTokenTypes.CF_TAG_NAME);
        if (childByType != null && "cfinterface".equalsIgnoreCase(childByType.getText())) {
            if ("cfinterface" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getTagName"));
            }
            return "cfinterface";
        }
        if ("cfcomponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getTagName"));
        }
        return "cfcomponent";
    }

    @Override
    public boolean isInterface() {
        String tagName = this.getTagName();
        return "cfinterface".equalsIgnoreCase(tagName);
    }

    @Override
    @Nullable
    public String getSuperName() {
        PsiElement rEx = this.getAttributeValueElement("extends");
        return rEx == null ? null : rEx.getText();
    }

    @Override
    public String[] getInterfaceNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public CfmlComponent[] getImplementedInterfaces() {
        return new CfmlComponent[0];
    }

    @Override
    @Nullable
    public CfmlComponent getSuper() {
        return CfmlPsiUtil.getSuperComponent(this);
    }

    @Override
    public CfmlComponentReference getSuperReference() {
        return CfmlPsiUtil.getSuperComponentReference(this);
    }

    @Override
    public boolean isTrulyDeclaration() {
        return true;
    }

    public PsiElement getNameIdentifier() {
        return this.getNavigationElement();
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = CfmlPsiUtil.getComponentReferencesFromAttributes(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/coldFusion/model/psi/impl/CfmlTagComponentImpl", "accept"));
        }
        if (visitor instanceof CfmlRecursiveElementVisitor) {
            ((CfmlRecursiveElementVisitor)visitor).visitCfmlComponent(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public boolean hasImplicitAccessors() {
        PsiElement accessors = this.getAttributeValueElement("accessors");
        if (accessors == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(accessors.getText()) || "true".equalsIgnoreCase(accessors.getText());
    }

    @Override
    public boolean isPersistent() {
        PsiElement persistentEl = this.getAttributeValueElement("persistent");
        if (persistentEl == null) {
            return false;
        }
        return "yes".equalsIgnoreCase(persistentEl.getText()) || "true".equalsIgnoreCase(persistentEl.getText());
    }
}

