/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.swing.ui.SwatchComponent;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateListPicker
extends JPanel {
    private static final String API_ERROR_TEXT = "This resource requires at least an API level of %d";
    private static final ResourceType[] DIMENSIONS_ONLY = new ResourceType[]{ResourceType.DIMEN};
    public static final String PRIVATE_ERROR_PATTERN = "%s is a private framework resource";
    public static final String NON_EXISTENT_ERROR_PATTERN = "The resource %s does not exist";
    private final Module myModule;
    private final Configuration myConfiguration;
    @Nullable
    private ResourceHelper.StateList myStateList;
    private List<StateComponent> myStateComponents;
    @NotNull
    private final RenderTask myRenderTask;
    private boolean myIsBackgroundStateList;
    @NotNull
    private ImmutableMap<String, Color> myContrastColorsWithDescription;

    public StateListPicker(@Nullable ResourceHelper.StateList stateList, @NotNull Module module, @NotNull Configuration configuration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/StateListPicker", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/StateListPicker", "<init>"));
        }
        this.myContrastColorsWithDescription = ImmutableMap.of();
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(module, configuration);
        this.setLayout(new BoxLayout(this, 1));
        if (stateList != null) {
            this.setStateList(stateList);
        }
    }

    public void setStateList(@NotNull ResourceHelper.StateList stateList) {
        if (stateList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateList", "com/android/tools/idea/editors/theme/StateListPicker", "setStateList"));
        }
        this.myStateList = stateList;
        this.myStateComponents = Lists.newArrayListWithCapacity((int)this.myStateList.getStates().size());
        this.removeAll();
        if (this.myStateList.getStates().isEmpty()) {
            this.add(new JLabel("Empty " + this.myStateList.getType() + " StateList"));
        }
        for (ResourceHelper.StateListState state : this.myStateList.getStates()) {
            StateComponent stateComponent = this.createStateComponent(state);
            this.add(stateComponent);
        }
        this.revalidate();
        this.repaint();
    }

    @NotNull
    private StateComponent createStateComponent(@NotNull ResourceHelper.StateListState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/theme/StateListPicker", "createStateComponent"));
        }
        StateComponent stateComponent = new StateComponent(this.myModule.getProject());
        this.myStateComponents.add(stateComponent);
        String stateValue = state.getValue();
        String alphaValue = state.getAlpha();
        stateComponent.addValueActionListener(new ValueActionListener(state, stateComponent));
        stateComponent.addAlphaActionListener(new AlphaActionListener(state, stateComponent));
        stateComponent.setValueText(stateValue);
        stateComponent.setAlphaValue(alphaValue);
        stateComponent.setAlphaVisible(!StringUtil.isEmpty((String)alphaValue));
        stateComponent.setNameText(state.getDescription());
        stateComponent.setComponentPopupMenu((JPopupMenu)this.createAlphaPopupMenu(state, stateComponent));
        StateComponent stateComponent2 = stateComponent;
        if (stateComponent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker", "createStateComponent"));
        }
        return stateComponent2;
    }

    @NotNull
    private JBPopupMenu createAlphaPopupMenu(final @NotNull ResourceHelper.StateListState state, final @NotNull StateComponent stateComponent) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/theme/StateListPicker", "createAlphaPopupMenu"));
        }
        if (stateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateComponent", "com/android/tools/idea/editors/theme/StateListPicker", "createAlphaPopupMenu"));
        }
        JBPopupMenu popupMenu = new JBPopupMenu();
        final JMenuItem deleteAlpha = new JMenuItem("Delete alpha");
        popupMenu.add(deleteAlpha);
        deleteAlpha.setVisible(!StringUtil.isEmpty((String)state.getAlpha()));
        final JMenuItem createAlpha = new JMenuItem("Create alpha");
        popupMenu.add(createAlpha);
        createAlpha.setVisible(StringUtil.isEmpty((String)state.getAlpha()));
        deleteAlpha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stateComponent.getAlphaComponent().setVisible(false);
                stateComponent.setAlphaValue(null);
                state.setAlpha(null);
                StateListPicker.this.updateIcon(stateComponent);
                deleteAlpha.setVisible(false);
                createAlpha.setVisible(true);
            }
        });
        createAlpha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaActionListener listener = stateComponent.getAlphaActionListener();
                if (listener == null) {
                    return;
                }
                listener.actionPerformed(new ActionEvent(stateComponent.getAlphaComponent(), 1001, null));
                if (!StringUtil.isEmpty((String)state.getAlpha())) {
                    stateComponent.getAlphaComponent().setVisible(true);
                    createAlpha.setVisible(false);
                    deleteAlpha.setVisible(true);
                }
            }
        });
        JBPopupMenu jBPopupMenu = popupMenu;
        if (jBPopupMenu == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker", "createAlphaPopupMenu"));
        }
        return jBPopupMenu;
    }

    @Nullable(value="if there is no error")
    public ValidationInfo getFrameworkResourceError() {
        IAndroidTarget target = this.myConfiguration.getTarget();
        assert (target != null);
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myModule);
        assert (androidTargetData != null);
        ResourceRepository frameworkResources = this.myConfiguration.getFrameworkResources();
        assert (frameworkResources != null);
        ValidationInfo error = null;
        for (StateComponent component : this.myStateComponents) {
            String resourceValue = component.getResourceValue();
            String errorText = null;
            if (component.getResourceComponent().hasWarningIcon()) {
                errorText = NON_EXISTENT_ERROR_PATTERN;
            } else if (StateListPicker.isResourcePrivate(resourceValue, androidTargetData)) {
                errorText = PRIVATE_ERROR_PATTERN;
            }
            if (errorText != null) {
                error = component.getResourceComponent().createSwatchValidationInfo(String.format(errorText, resourceValue));
                break;
            }
            resourceValue = component.getAlphaValue();
            if (resourceValue == null) continue;
            if (component.getAlphaComponent().hasWarningIcon()) {
                errorText = NON_EXISTENT_ERROR_PATTERN;
            } else if (StateListPicker.isResourcePrivate(resourceValue, androidTargetData)) {
                errorText = PRIVATE_ERROR_PATTERN;
            }
            if (errorText == null) continue;
            error = new ValidationInfo(String.format(errorText, resourceValue), (JComponent)component.getAlphaComponent());
            break;
        }
        return error;
    }

    @Nullable(value="if there is no such component")
    public ValidationInfo getApiError(int minApi) {
        for (StateComponent component : this.myStateComponents) {
            int resourceApi = ResolutionUtils.getOriginalApiLevel(component.getResourceValue(), this.myModule.getProject());
            if (resourceApi > minApi) {
                return component.getResourceComponent().createSwatchValidationInfo(String.format(API_ERROR_TEXT, resourceApi));
            }
            int alphaApi = ResolutionUtils.getOriginalApiLevel(component.getAlphaValue(), this.myModule.getProject());
            if (alphaApi <= minApi) continue;
            return new ValidationInfo(String.format(API_ERROR_TEXT, alphaApi), (JComponent)component.getAlphaComponent());
        }
        return null;
    }

    private static boolean isResourcePrivate(@NotNull String resourceValue, @NotNull AndroidTargetData targetData) {
        if (resourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceValue", "com/android/tools/idea/editors/theme/StateListPicker", "isResourcePrivate"));
        }
        if (targetData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetData", "com/android/tools/idea/editors/theme/StateListPicker", "isResourcePrivate"));
        }
        ResourceUrl url = ResourceUrl.parse((String)resourceValue);
        return url != null && url.framework && !targetData.isResourcePublic(url.type.getName(), url.name);
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackgroundStateList) {
        if (contrastColorsWithDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contrastColorsWithDescription", "com/android/tools/idea/editors/theme/StateListPicker", "setContrastParameters"));
        }
        this.myContrastColorsWithDescription = contrastColorsWithDescription;
        this.myIsBackgroundStateList = isBackgroundStateList;
    }

    @Nullable
    public ResourceHelper.StateList getStateList() {
        return this.myStateList;
    }

    private void updateIcon(@NotNull StateComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/theme/StateListPicker", "updateIcon"));
        }
        component.showAlphaError(false);
        ResourceResolver resourceResolver = this.myConfiguration.getResourceResolver();
        assert (resourceResolver != null);
        String resourceName = component.getResourceValue();
        ResourceValue resValue = resourceResolver.findResValue(resourceName, false);
        if ((resValue = resourceResolver.resolveResValue(resValue)) != null && resValue.getResourceType() != ResourceType.COLOR) {
            List<BufferedImage> images = this.myRenderTask.renderDrawableAllStates(resValue);
            if (images.isEmpty()) {
                component.setValueIcon(SwatchComponent.WARNING_ICON);
            } else {
                component.setValueIcon(new SwatchComponent.SquareImageIcon((BufferedImage)Iterables.getLast(images)));
            }
            component.showStack(images.size() > 1);
        } else {
            List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, resValue, this.myModule.getProject());
            if (colors.isEmpty()) {
                Color colorValue = ResourceHelper.parseColor(resourceName);
                if (colorValue != null) {
                    component.setValueIcon(new SwatchComponent.ColorIcon(colorValue));
                } else {
                    component.setValueIcon(SwatchComponent.WARNING_ICON);
                }
            } else {
                component.setValueIcon(new SwatchComponent.ColorIcon((Color)Iterables.getLast(colors)));
            }
            component.showStack(colors.size() > 1);
            String alphaValue = component.getAlphaValue();
            if (!StringUtil.isEmpty((String)alphaValue)) {
                try {
                    float alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resourceResolver, alphaValue));
                    JBFont iconFont = JBUI.Fonts.smallFont().asBold();
                    component.getAlphaComponent().setSwatchIcon(new SwatchComponent.TextIcon(String.format("%.2f", Float.valueOf(alpha)), (Font)iconFont));
                }
                catch (NumberFormatException e) {
                    component.showAlphaError(true);
                    component.getAlphaComponent().setSwatchIcon(SwatchComponent.WARNING_ICON);
                }
            } else {
                JBFont iconFont = JBUI.Fonts.smallFont().asBold();
                component.getAlphaComponent().setSwatchIcon(new SwatchComponent.TextIcon("1.00", (Font)iconFont));
            }
        }
    }

    private void repaintAllComponents() {
        for (StateComponent component : this.myStateComponents) {
            this.updateIcon(component);
            component.repaint();
        }
    }

    private class StateComponent
    extends Box {
        private final ResourceComponent myResourceComponent;
        private final SwatchComponent myAlphaComponent;
        private final JBLabel myAlphaErrorLabel;
        private AlphaActionListener myAlphaActionListener;

        public StateComponent(Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "<init>"));
            }
            super(3);
            this.myResourceComponent = new ResourceComponent(project, true);
            this.add(this.myResourceComponent);
            this.myResourceComponent.setMaximumSize(new Dimension(this.myResourceComponent.getMaximumSize().width, this.myResourceComponent.getPreferredSize().height));
            this.myResourceComponent.setVariantComboVisible(false);
            this.myAlphaComponent = new SwatchComponent(project, true);
            this.add(this.myAlphaComponent);
            Font font = StateListPicker.this.getFont();
            this.setFont(ThemeEditorUtils.scaleFontForAttribute(font));
            this.myAlphaComponent.setMaximumSize(new Dimension(this.myAlphaComponent.getMaximumSize().width, this.myAlphaComponent.getPreferredSize().height));
            Box alphaErrorComponent = new Box(2);
            this.myAlphaErrorLabel = new JBLabel("This value does not resolve to a floating-point number.", AllIcons.General.BalloonWarning, 10);
            this.myAlphaErrorLabel.setVisible(false);
            alphaErrorComponent.add((Component)this.myAlphaErrorLabel);
            alphaErrorComponent.add(Box.createHorizontalGlue());
            this.add(alphaErrorComponent);
        }

        @NotNull
        public ResourceComponent getResourceComponent() {
            ResourceComponent resourceComponent = this.myResourceComponent;
            if (resourceComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getResourceComponent"));
            }
            return resourceComponent;
        }

        @NotNull
        public SwatchComponent getAlphaComponent() {
            SwatchComponent swatchComponent = this.myAlphaComponent;
            if (swatchComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getAlphaComponent"));
            }
            return swatchComponent;
        }

        public void showAlphaError(boolean hasError) {
            this.myAlphaErrorLabel.setVisible(hasError);
            this.myAlphaComponent.setWarningBorder(hasError);
        }

        public void setNameText(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "setNameText"));
            }
            this.myResourceComponent.setNameText(name);
        }

        public void setValueText(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "setValueText"));
            }
            this.myResourceComponent.setValueText(value);
        }

        public void setAlphaValue(@Nullable String alphaValue) {
            this.myAlphaComponent.setText(Strings.nullToEmpty((String)alphaValue));
        }

        public void setAlphaVisible(boolean isVisible) {
            this.myAlphaComponent.setVisible(isVisible);
        }

        public void setValueIcon(@NotNull SwatchComponent.SwatchIcon icon) {
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "setValueIcon"));
            }
            this.myResourceComponent.setSwatchIcon(icon);
        }

        public void showStack(boolean show) {
            this.myResourceComponent.showStack(show);
        }

        @NotNull
        public String getResourceValue() {
            String string = this.myResourceComponent.getValueText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getResourceValue"));
            }
            return string;
        }

        @Nullable
        public String getAlphaValue() {
            return this.myAlphaComponent.getText();
        }

        public void addValueActionListener(@NotNull ValueActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "addValueActionListener"));
            }
            this.myResourceComponent.addSwatchListener(listener);
            this.myResourceComponent.addTextDocumentListener(listener);
        }

        public void addAlphaActionListener(@NotNull AlphaActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "addAlphaActionListener"));
            }
            this.myAlphaComponent.addSwatchListener(listener);
            this.myAlphaComponent.addTextDocumentListener(listener);
            this.myAlphaActionListener = listener;
        }

        @Nullable
        public AlphaActionListener getAlphaActionListener() {
            return this.myAlphaActionListener;
        }

        @Override
        public void setComponentPopupMenu(JPopupMenu popup) {
            super.setComponentPopupMenu(popup);
            this.myResourceComponent.setComponentPopupMenu(popup);
            this.myAlphaComponent.setComponentPopupMenu(popup);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.myResourceComponent != null) {
                this.myResourceComponent.setFont(font);
            }
            if (this.myAlphaComponent != null) {
                this.myAlphaComponent.setFont(font);
            }
        }
    }

    private class AlphaActionListener
    implements ActionListener,
    DocumentListener {
        private final ResourceHelper.StateListState myState;
        private final StateComponent myComponent;

        public AlphaActionListener(ResourceHelper.StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        public void beforeDocumentChange(DocumentEvent e) {
            AndroidFacet facet = AndroidFacet.getInstance(StateListPicker.this.myModule);
            assert (facet != null);
            this.myComponent.getAlphaComponent().setCompletionStrings(ResourceHelper.getCompletionFromTypes(facet, DIMENSIONS_ONLY));
        }

        public void documentChanged(DocumentEvent e) {
            this.myState.setAlpha(this.myComponent.getAlphaValue());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StateListPicker.this.updateIcon(AlphaActionListener.this.myComponent);
                    AlphaActionListener.this.myComponent.repaint();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwatchComponent source = this.myComponent.getAlphaComponent();
            String itemValue = source.getText();
            ResourceResolver resourceResolver = StateListPicker.this.myConfiguration.getResourceResolver();
            assert (resourceResolver != null);
            ResourceValue resValue = resourceResolver.findResValue(itemValue, false);
            String resolvedResource = resValue != null ? resourceResolver.resolveResValue(resValue).getName() : itemValue;
            ChooseResourceDialog dialog = new ChooseResourceDialog(StateListPicker.this.myModule, DIMENSIONS_ONLY, resolvedResource, null);
            dialog.show();
            if (dialog.isOK()) {
                String resourceName = dialog.getResourceName();
                this.myState.setAlpha(resourceName);
                this.myComponent.setAlphaValue(resourceName);
                StateListPicker.this.repaintAllComponents();
            }
        }
    }

    class ValueActionListener
    implements ActionListener,
    DocumentListener {
        private final ResourceHelper.StateListState myState;
        private final StateComponent myComponent;

        public ValueActionListener(ResourceHelper.StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        public void beforeDocumentChange(DocumentEvent e) {
            AndroidFacet facet = AndroidFacet.getInstance(StateListPicker.this.myModule);
            assert (facet != null);
            assert (StateListPicker.this.myStateList != null);
            List<String> completionStrings = ResourceHelper.getCompletionFromTypes(facet, StateListPicker.this.myStateList.getFolderType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY);
            this.myComponent.getResourceComponent().setCompletionStrings(completionStrings);
        }

        public void documentChanged(DocumentEvent e) {
            this.myState.setValue(this.myComponent.getResourceValue());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StateListPicker.this.updateIcon(ValueActionListener.this.myComponent);
                    ValueActionListener.this.myComponent.repaint();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nameSuggestion;
            ResourceComponent resourceComponent = this.myComponent.getResourceComponent();
            String attributeValue = resourceComponent.getValueText();
            ResourceUrl attributeValueUrl = ResourceUrl.parse((String)attributeValue);
            boolean isFrameworkValue = attributeValueUrl != null && attributeValueUrl.framework;
            String string = nameSuggestion = attributeValueUrl != null ? attributeValueUrl.name : attributeValue;
            assert (StateListPicker.this.myStateList != null);
            ResourceType[] allowedTypes = StateListPicker.this.myStateList.getFolderType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY;
            ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.FORCE;
            if (nameSuggestion.startsWith("#")) {
                nameSuggestion = null;
                resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.SHOW;
            }
            ChooseResourceDialog dialog = new ChooseResourceDialog(StateListPicker.this.myModule, allowedTypes, attributeValue, isFrameworkValue, resourceNameVisibility, nameSuggestion);
            if (!StateListPicker.this.myContrastColorsWithDescription.isEmpty()) {
                dialog.setContrastParameters((ImmutableMap<String, Color>)StateListPicker.this.myContrastColorsWithDescription, StateListPicker.this.myIsBackgroundStateList, !StateListPicker.this.myStateList.getDisabledStates().contains((Object)this.myState));
            }
            dialog.show();
            if (dialog.isOK()) {
                String resourceName = dialog.getResourceName();
                this.myState.setValue(resourceName);
                this.myComponent.setValueText(resourceName);
                StateListPicker.this.repaintAllComponents();
            }
        }
    }
}

