/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OldAndroidPluginErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/OldAndroidPluginErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/OldAndroidPluginErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/OldAndroidPluginErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/OldAndroidPluginErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        if (firstLine.startsWith("Plugin is too old, please update to a more recent version")) {
            ArrayList hyperlinks = Lists.newArrayList();
            hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink(false));
            String filePath = notification.getFilePath();
            if (StringUtil.isNotEmpty((String)filePath)) {
                Integer line = notification.getLine();
                hyperlinks.add(new OpenFileHyperlink(filePath, "Open File", line - 1, notification.getColumn()));
            }
            String newMsg = Joiner.on((char)'\n').join(message);
            OldAndroidPluginErrorHandler.updateNotification(notification, project, newMsg, hyperlinks);
            return true;
        }
        return false;
    }
}

