/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.android.designer.AndroidDesignerEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

public final class AndroidDesignerEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ANDROID_DESIGNER_ID = "android-designer";

    public static boolean acceptLayout(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/android/designer/AndroidDesignerEditorProvider", "acceptLayout"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/android/designer/AndroidDesignerEditorProvider", "acceptLayout"));
        }
        if (RenderService.NELE_ENABLED) {
            return false;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        return psiFile instanceof XmlFile && AndroidFacet.getInstance((PsiElement)psiFile) != null && LayoutDomFileDescription.isLayoutFile((XmlFile)psiFile);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/android/designer/AndroidDesignerEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/android/designer/AndroidDesignerEditorProvider", "accept"));
        }
        return AndroidDesignerEditorProvider.acceptLayout(project, file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/android/designer/AndroidDesignerEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/android/designer/AndroidDesignerEditorProvider", "createEditor"));
        }
        AndroidDesignerEditor androidDesignerEditor = new AndroidDesignerEditor(project, file);
        if (androidDesignerEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerEditorProvider", "createEditor"));
        }
        return androidDesignerEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (ANDROID_DESIGNER_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerEditorProvider", "getEditorTypeId"));
        }
        return ANDROID_DESIGNER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR : FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

