/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.res2.ResourceItem;
import com.google.common.collect.Lists;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceDialogSouthPanel {
    private JTextField myResourceNameField;
    private JBLabel myResourceNameMessage;
    private JPanel myFullPanel;
    private JPanel myExpertPlaceholder;
    private JPanel myExpertPanel;
    private JComboBox myVariantComboBox;
    private HideableDecorator myExpertDecorator;
    @NotNull
    private List<ResourceItem> myVariants;

    public ResourceDialogSouthPanel() {
        this.$$$setupUI$$$();
        this.myVariants = Collections.emptyList();
        Color backgroundColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
        this.myResourceNameMessage.setBackground((Color)(backgroundColor == null ? JBColor.YELLOW : backgroundColor));
        this.myExpertDecorator = new HideableDecorator(this.myExpertPlaceholder, "Device Configuration", true){

            private void pack() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.getWindowAncestor(ResourceDialogSouthPanel.this.myExpertPlaceholder).pack();
                    }
                });
            }

            protected void on() {
                super.on();
                this.pack();
            }

            protected void off() {
                super.off();
                this.pack();
            }
        };
        this.myExpertDecorator.setContentComponent((JComponent)this.myExpertPanel);
    }

    public void setExpertPanel(Component comp) {
        this.myExpertPanel.removeAll();
        this.myExpertPanel.add(comp);
    }

    public void showExpertPanel(boolean show) {
        this.myExpertPlaceholder.setVisible(show);
    }

    public JPanel getFullPanel() {
        return this.myFullPanel;
    }

    public JBLabel getResourceNameMessage() {
        return this.myResourceNameMessage;
    }

    public JTextField getResourceNameField() {
        return this.myResourceNameField;
    }

    public void setOn(boolean on) {
        this.myExpertDecorator.setOn(on);
    }

    public void addVariantActionListener(@NotNull ActionListener al) {
        if (al == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "al", "org/jetbrains/android/uipreview/ResourceDialogSouthPanel", "addVariantActionListener"));
        }
        this.myVariantComboBox.addActionListener(al);
    }

    public void setVariant(@NotNull List<ResourceItem> resources, @Nullable ResourceItem defaultValue) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/android/uipreview/ResourceDialogSouthPanel", "setVariant"));
        }
        if (resources.size() > 1) {
            resources = Lists.newArrayList(resources);
            Collections.sort(resources, new Comparator<ResourceItem>(){

                @Override
                public int compare(ResourceItem element1, ResourceItem element2) {
                    File directory1 = element1.getFile().getParentFile();
                    File directory2 = element2.getFile().getParentFile();
                    return directory1.getName().compareTo(directory2.getName());
                }
            });
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            String defaultSelection = null;
            for (ResourceItem resource : resources) {
                String name = resource.getFile().getParentFile().getName();
                model.addElement(name);
                if (defaultSelection != null || resource != defaultValue) continue;
                defaultSelection = name;
            }
            model.setSelectedItem(defaultSelection);
            this.myVariantComboBox.setModel(model);
        }
        this.myVariants = resources;
        this.myVariantComboBox.setVisible(resources.size() > 1);
    }

    @NotNull
    public ResourceItem getSelectedVariant() {
        ResourceItem resourceItem = this.myVariants.size() > 1 ? this.myVariants.get(this.myVariantComboBox.getSelectedIndex()) : this.myVariants.get(0);
        if (resourceItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ResourceDialogSouthPanel", "getSelectedVariant"));
        }
        return resourceItem;
    }

    public void setSelectedVariant(@NotNull ResourceItem selectedVariant) {
        if (selectedVariant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedVariant", "org/jetbrains/android/uipreview/ResourceDialogSouthPanel", "setSelectedVariant"));
        }
        if (this.myVariants.size() == 1) {
            assert (this.myVariants.get(0) == selectedVariant);
        } else {
            ComboBoxModel model = this.myVariantComboBox.getModel();
            model.setSelectedItem(model.getElementAt(this.myVariants.indexOf(selectedVariant)));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel3;
        this.myFullPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myResourceNameMessage = jBLabel = new JBLabel();
        jBLabel.setOpaque(true);
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myExpertPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myExpertPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
        this.myVariantComboBox = jComboBox = new JComboBox();
        jComboBox.setMaximumRowCount(15);
        ((Component)jComboBox).setVisible(false);
        jPanel3.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myFullPanel;
    }
}

