/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.model.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.spring.model.converters.SpringBeanMethodConverter;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.osgi.model.xml.BasicListener;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BasicListenerMethodConverter
extends SpringBeanMethodConverter {
    protected PsiMethodConverter.MethodAccepter getMethodAccepter(final ConvertContext context, final boolean forCompletion) {
        return new PsiMethodConverter.MethodAccepter(){

            public boolean accept(PsiMethod method) {
                String containing = method.getContainingClass().getQualifiedName();
                return BasicListenerMethodConverter.this.checkParameterList(method, context) && BasicListenerMethodConverter.this.checkModifiers(method) && BasicListenerMethodConverter.this.checkReturnType(context, method, forCompletion) && !method.isConstructor() && containing != null && !containing.equals("java.lang.Object");
            }
        };
    }

    protected PsiClass getPsiClass(ConvertContext context) {
        BasicListener registrationListener = BasicListenerMethodConverter.getBasicListener(context);
        if (registrationListener != null) {
            if (!DomUtil.hasXml(registrationListener.getRef())) {
                SpringBean bean = registrationListener.getBean();
                if (bean != null) {
                    return PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
                }
            } else {
                SpringBeanPointer value = (SpringBeanPointer)registrationListener.getRef().getValue();
                if (value != null) {
                    return value.getBeanClass();
                }
            }
        }
        return null;
    }

    @Nullable
    private static BasicListener getBasicListener(ConvertContext context) {
        return (BasicListener)context.getInvocationElement().getParentOfType(BasicListener.class, false);
    }

    protected abstract boolean checkParameterList(PsiMethod var1, ConvertContext var2);

    public static boolean checkType(@Nullable PsiType type, String className, Project project) {
        if (type == null) {
            return false;
        }
        if (className.equals(type.getCanonicalText())) {
            return true;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        return psiClass != null && type.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)psiClass));
    }

    protected boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        PsiType returnType = method.getReturnType();
        return PsiType.VOID.equals((Object)returnType);
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return LocalQuickFix.EMPTY_ARRAY;
    }
}

