/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforcePasswordNotAllowedException
extends VcsConnectionProblem {
    private final Project myProject;
    private final P4Connection myConnection;

    public PerforcePasswordNotAllowedException(String message, Project project, P4Connection connection) {
        super(message);
        this.myProject = project;
        this.myConnection = connection;
    }

    public boolean attemptQuickFix(boolean mayDisplayDialogs) {
        PerforceSettings mySettings = PerforceSettings.getSettings(this.myProject);
        if (!mySettings.USE_LOGIN && mySettings.ENABLED) {
            if (mayDisplayDialogs) {
                return PerforceAuthenticationException.askEnableLogin(PerforceBundle.message((String)"confirmation.text.password.not.allowed.enable.login", (Object[])new Object[0]), this.myProject);
            }
            PerforceLoginManager.getInstance(this.myProject).ensureNotifyAboutDisabledLogin(this.myConnection);
        } else if (mySettings.USE_LOGIN && mySettings.useP4CONFIG) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)this.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }
        return false;
    }
}

