/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Timed;
import com.intellij.util.Consumer;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntervalStatistics<Data, T extends Consumer<Data>, U extends Consumer<T>> {
    private static final int ourMaxHistoryQueue = 10;
    private static final int ourDefaultInterval = 600000;
    private final long myIntervalInMillis;
    private final int myHistoryQueueSize;
    private final Factory<T> myFactory;
    @NotNull
    private final U myAverage;
    @NotNull
    private final LinkedList<Timed<T>> myRecentComplete = new LinkedList();
    private final Object myLock = new Object();
    @NotNull
    private Timed<T> myCurrent;
    @Nullable
    private final Runnable mySwitchListener;

    protected IntervalStatistics(long intervalInMillis, int historyQueueSize, Factory<T> factory, Factory<U> averageFactory, @Nullable Runnable switchListener) {
        this.mySwitchListener = switchListener;
        this.myIntervalInMillis = intervalInMillis <= 0L ? 600000L : intervalInMillis;
        this.myHistoryQueueSize = historyQueueSize <= 0 ? 10 : historyQueueSize;
        this.myFactory = factory;
        this.myAverage = (Consumer)averageFactory.create();
        this.myCurrent = new Timed(this.myFactory.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void step(Data data) {
        long currentTime = System.currentTimeMillis();
        Object object = this.myLock;
        synchronized (object) {
            ((Consumer)this.myCurrent.getT()).consume(data);
            if (currentTime - this.myCurrent.getTime() < this.myIntervalInMillis) {
                return;
            }
            this.addToQueue(this.myCurrent);
            this.myAverage.consume(this.myCurrent.getT());
            this.myCurrent = new Timed(this.myFactory.create());
        }
        if (this.mySwitchListener != null) {
            this.mySwitchListener.run();
        }
    }

    private void addToQueue(Timed<T> timed) {
        if (this.myRecentComplete.size() == this.myHistoryQueueSize) {
            this.myRecentComplete.removeLast();
        }
        this.myRecentComplete.addFirst(timed);
    }

    @NotNull
    public U getAverage() {
        U u = this.myAverage;
        if (u == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/util/tracer/IntervalStatistics", "getAverage"));
        }
        return u;
    }

    public List<Timed<T>> receiveRecentComplete() {
        LinkedList<Timed<T>> result = new LinkedList<Timed<T>>(this.myRecentComplete);
        this.myRecentComplete.clear();
        return result;
    }
}

