/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.CoffeeScriptUtil;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/highlighter/CoffeeScriptErrorFilter", "shouldHighlightErrorElement"));
        }
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        if (viewProvider instanceof InjectedFileViewProvider) {
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost((PsiElement)element);
            PsiElement container = CoffeeScriptUtil.getContainer((PsiElement)host);
            if (container == null) {
                return true;
            }
            if (container.getLanguage() == CoffeeScriptLanguage.INSTANCE) {
                String languageId = element.getLanguage().getID();
                if (element.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || languageId.equals("CSS") || languageId.equals("HTML")) {
                    return false;
                }
            } else {
                return element.getLanguage() != CoffeeScriptLanguage.INSTANCE;
            }
        }
        return true;
    }
}

