/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.List;
import org.coffeescript.CsBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoffeeScriptIntroduceHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, final Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "invoke"));
        }
        List<PsiElement> expressions = CoffeeScriptIntroduceHandler.collectExpressions(editor, file);
        if (expressions.size() == 0) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)CsBundle.message("refactorings.introduce.cant.introduce.message", new Object[0]), (String)CsBundle.message("refactorings.introduce.cant.introduce.title", new Object[0]), (String)"refactoring.extract.variable.coffeescript");
        } else if (expressions.size() == 1) {
            PsiElement element = expressions.get(0);
            if (element != null) {
                this.processIntroduce(editor, element);
            }
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<PsiElement>(){

                public void pass(PsiElement selectedValue) {
                    SmartPsiElementPointer myElementPointer = SmartPointerManager.getInstance((Project)selectedValue.getProject()).createSmartPsiElementPointer(selectedValue);
                    CoffeeScriptIntroduceHandler.this.processIntroduce(editor, myElementPointer);
                }
            }, grExpression -> grExpression.getText());
        }
    }

    private static List<PsiElement> collectExpressions(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "collectExpressions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "collectExpressions"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        if (editor.getSelectionModel().hasSelection()) {
            PsiElement element1 = file.findElementAt(editor.getSelectionModel().getSelectionStart());
            PsiElement element2 = file.findElementAt(editor.getSelectionModel().getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                int startOffset = element1.getTextRange().getEndOffset();
                element1 = file.findElementAt(startOffset);
            }
            if (element2 instanceof PsiWhiteSpace) {
                int endOffset = element2.getTextRange().getStartOffset();
                element2 = file.findElementAt(endOffset - 1);
            }
            if (element1 != null && element2 != null) {
                result.add((PsiElement)CoffeeScriptIntroduceHandler.getSelectedExpression(element1, element2));
            }
        } else {
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (element != null) {
                while (element != null && element.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && !(element instanceof JSBlockStatement)) {
                    if (!(!(element instanceof JSExpression) || element instanceof JSObjectLiteralExpression && element.getParent() != null && element.getParent().getParent() != null && element.getParent().getParent().getParent() instanceof JSClassImpl)) {
                        result.add(element);
                    }
                    element = element.getParent();
                }
            }
        }
        return result;
    }

    private void processIntroduce(Editor editor, @NotNull SmartPsiElementPointer elementPointer) {
        if (elementPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementPointer", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "processIntroduce"));
        }
        PsiElement element = elementPointer.getElement();
        if (element == null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)CsBundle.message("refactorings.introduce.cant.introduce.message", new Object[0]), (String)CsBundle.message("refactorings.introduce.cant.introduce.title", new Object[0]), (String)"refactoring.extract.variable.coffeescript");
            return;
        }
        this.processIntroduce(editor, element);
    }

    @Nullable
    public static JSExpression getSelectedExpression(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "getSelectedExpression"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "getSelectedExpression"));
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        if (parent instanceof JSExpression) {
            return (JSExpression)parent;
        }
        return (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSExpression.class);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/coffeescript/refactoring/CoffeeScriptIntroduceHandler", "invoke"));
        }
    }

    protected abstract void processIntroduce(@NotNull Editor var1, @NotNull PsiElement var2);
}

