/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithWhileSurrounder
extends CoffeeScriptBaseSurrounder {
    public String getTemplateDescription() {
        return CsBundle.message("surrounder.while", new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/coffeescript/refactoring/surround/CoffeeScriptWithWhileSurrounder", "isApplicable"));
        }
        return true;
    }

    @Override
    protected String getStatementTemplate(PsiElement context) {
        return "while condition\n  body";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        ASTNode aSTNode = surroundedNode.getLastChildNode().getFirstChildNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/refactoring/surround/CoffeeScriptWithWhileSurrounder", "getNodeToReplace"));
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSWhileStatement whileStatement = (JSWhileStatement)statementNode.getPsi();
        int startOffset = whileStatement.getCondition().getTextOffset();
        int endOffset = startOffset + whileStatement.getCondition().getTextLength();
        return new TextRange(startOffset, endOffset);
    }
}

