/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0015"}, d2={"combineIfNoConflicts", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "other", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "hasConflictWith", "", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "isAlmostEverything", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "presentationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toFuzzyType", "ide-common"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(@NotNull CallableDescriptor $receiver) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            Collection collection = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType, collection);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(@NotNull CallableDescriptor $receiver) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Annotated annotated = $receiver.getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            Collection collection = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType((KotlinType)annotated, collection);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNotNullable($receiver.getType()), (Collection<? extends TypeParameterDescriptor>)$receiver.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNullable($receiver.getType()), (Collection<? extends TypeParameterDescriptor>)$receiver.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return TypeUtilsKt.nullability($receiver.getType());
    }

    public static final boolean isAlmostEverything(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.getFreeParameters().isEmpty()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getType().getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter = typeParameterDescriptor;
        if ($receiver.getFreeParameters().contains(typeParameter) ^ true) {
            return false;
        }
        KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull(typeParameter.getUpperBounds());
        return kotlinType != null ? TypeUtilsKt.isAnyOrNullableAny(kotlinType) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType presentationType(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.getFreeParameters().isEmpty()) {
            return $receiver.getType();
        }
        HashMap map2 = new HashMap();
        Iterable iterable = $receiver.getType().getArguments();
        Iterable iterable2 = $receiver.getType().getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"type.constructor.parameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)iterable2)) {
            TypeParameterDescriptor equalToFreeParameter;
            Object v2;
            Object object;
            TypeParameterDescriptor typeParameter;
            block5: {
                void $receiver$iv;
                TypeProjection argument2 = (TypeProjection)pair2.component1();
                typeParameter = (TypeParameterDescriptor)pair2.component2();
                if (!Intrinsics.areEqual((Object)((Object)argument2.getProjectionKind()), (Object)((Object)Variance.INVARIANT))) continue;
                object = $receiver.getFreeParameters();
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    if (!KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(it.getDefaultType(), argument2.getType())) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            if ((TypeParameterDescriptor)v2 == null) {
                continue;
            }
            object = map2;
            TypeConstructor typeConstructor2 = equalToFreeParameter.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"equalToFreeParameter.typeConstructor");
            TypeConstructor typeConstructor3 = typeConstructor2;
            KotlinType kotlinType = typeParameter.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"typeParameter.defaultType");
            TypeProjection typeProjection = TypeUtilsKt.createProjection(kotlinType, Variance.INVARIANT, null);
            object.put(typeConstructor3, typeProjection);
        }
        TypeSubstitutor substitutor3 = TypeSubstitutor.create(map2);
        KotlinType kotlinType = substitutor3.substitute($receiver.getType(), Variance.INVARIANT);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType;
    }

    @NotNull
    public static final FuzzyType toFuzzyType(@NotNull KotlinType $receiver, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(freeParameters, (String)"freeParameters");
        return new FuzzyType($receiver, freeParameters);
    }

    public static final boolean hasConflictWith(@NotNull TypeSubstitution $receiver, @NotNull TypeSubstitution other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            Intrinsics.checkParameterIsNotNull(freeParameters, (String)"freeParameters");
            Iterable $receiver$iv = freeParameters;
            for (Object element$iv : $receiver$iv) {
                boolean bl2;
                KotlinType type2;
                TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                KotlinType kotlinType = type2 = parameter.getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
                if ($receiver.get(kotlinType) == null) {
                    bl2 = false;
                } else {
                    TypeProjection substituted2;
                    TypeProjection substituted1;
                    KotlinType kotlinType2 = type2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                    bl2 = other.get(kotlinType2) == null ? false : !KotlinTypeChecker.FLEXIBLE_UNEQUAL_TO_INFLEXIBLE.equalTypes(substituted1.getType(), substituted2.getType()) || Intrinsics.areEqual((Object)((Object)substituted1.getProjectionKind()), (Object)((Object)substituted2.getProjectionKind())) ^ true;
                }
                if (!bl2) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final TypeSubstitutor combineIfNoConflicts(@NotNull TypeSubstitutor $receiver, @NotNull TypeSubstitutor other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull(freeParameters, (String)"freeParameters");
        TypeSubstitution typeSubstitution = $receiver.getSubstitution();
        TypeSubstitution typeSubstitution2 = other.getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitution2, (String)"other.substitution");
        if (FuzzyTypeUtils.hasConflictWith(typeSubstitution, typeSubstitution2, freeParameters)) {
            return null;
        }
        return TypeSubstitutor.createChainedSubstitutor($receiver.getSubstitution(), other.getSubstitution());
    }
}

