/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.editor;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.editor.TraceResultTextAttributes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import icons.SpyJSIcons;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceColorSettingsPage
implements ColorSettingsPage,
DisplayPrioritySortable {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.functionScope", new Object[0]), TraceResultTextAttributes.FUNCTION_SCOPE), new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.programScope", new Object[0]), TraceResultTextAttributes.PROGRAM_SCOPE), new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.exception", new Object[0]), TraceResultTextAttributes.EXCEPTION), new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.valueHint", new Object[0]), TraceResultTextAttributes.VALUE_HINT), new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.statement", new Object[0]), TraceResultTextAttributes.PATH_LEVEL_ONE), new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.inlineStatement", new Object[0]), TraceResultTextAttributes.PATH_LEVEL_TWO), new AttributesDescriptor(TraceBundle.message("configuration.colorSettings.executionTime", new Object[0]), TraceResultTextAttributes.EXECUTION_TIME)};
    private static final ColorDescriptor[] COLORS = ColorDescriptor.EMPTY_ARRAY;
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();

    @Nullable
    public Icon getIcon() {
        return SpyJSIcons.Spy_js;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)JavaScriptFileType.INSTANCE, null, null);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/TraceColorSettingsPage", "getHighlighter"));
        }
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("<ps><st>var globalVar = 'value';</st>\n\n<fs><hint>function</hint> Todo(<hint>param1</hint>, <hint>param2</hint>) {  <et>executed in 1.2345 ms</et>\n  <st>var x = 2;</st>\n\n  if (<st><in>globalVar</in> && <in>x < 3</in></st>) {\n    <st><hint>return</hint> (x > 2) ? 'more than two' : <in>'less than three'</in>;</st>\n  } else {\n    return '';\n  }\n}</fs>\n\n<st>globalVar += '1';</st>\n\n<ex><hint>function</hint> throwsEx() {  <et>executed in 0.1234 ms</et>\n\n  <st>var a = 1;</st>\n\n  <st>throw new Error();</st>\n\n  a++;\n}</ex></ps>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/TraceColorSettingsPage", "getDemoText"));
        }
        return "<ps><st>var globalVar = 'value';</st>\n\n<fs><hint>function</hint> Todo(<hint>param1</hint>, <hint>param2</hint>) {  <et>executed in 1.2345 ms</et>\n  <st>var x = 2;</st>\n\n  if (<st><in>globalVar</in> && <in>x < 3</in></st>) {\n    <st><hint>return</hint> (x > 2) ? 'more than two' : <in>'less than three'</in>;</st>\n  } else {\n    return '';\n  }\n}</fs>\n\n<st>globalVar += '1';</st>\n\n<ex><hint>function</hint> throwsEx() {  <et>executed in 0.1234 ms</et>\n\n  <st>var a = 1;</st>\n\n  <st>throw new Error();</st>\n\n  a++;\n}</ex></ps>";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/TraceColorSettingsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (COLORS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/TraceColorSettingsPage", "getColorDescriptors"));
        }
        return COLORS;
    }

    @NotNull
    public String getDisplayName() {
        String string = TraceBundle.message("configuration.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/editor/TraceColorSettingsPage", "getDisplayName"));
        }
        return string;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.OTHER_SETTINGS;
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("fs", TraceResultTextAttributes.FUNCTION_SCOPE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("ps", TraceResultTextAttributes.PROGRAM_SCOPE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("ex", TraceResultTextAttributes.EXCEPTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("hint", TraceResultTextAttributes.VALUE_HINT);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("st", TraceResultTextAttributes.PATH_LEVEL_ONE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("in", TraceResultTextAttributes.PATH_LEVEL_TWO);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("et", TraceResultTextAttributes.EXECUTION_TIME);
    }
}

