/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.actions;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceLoadedHandler;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import icons.SpyJSIcons;
import org.jetbrains.annotations.NotNull;

public class LoadTraceAction
extends AnAction {
    private TraceSession mySession;
    private Runnable myLoaded;

    public LoadTraceAction(@NotNull TraceSession session, @NotNull Runnable loaded) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/javascript/trace/execution/actions/LoadTraceAction", "<init>"));
        }
        if (loaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loaded", "com/intellij/javascript/trace/execution/actions/LoadTraceAction", "<init>"));
        }
        super(TraceBundle.message("console.trace.toolbar.loadTrace", new Object[0]), TraceBundle.message("console.trace.toolbar.loadTrace", new Object[0]), SpyJSIcons.LoadTrace);
        this.mySession = session;
        this.myLoaded = loaded;
    }

    public void update(AnActionEvent e) {
        if (!this.mySession.isRunning()) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/actions/LoadTraceAction", "actionPerformed"));
        }
        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(new FileChooserDescriptor(true, false, true, false, false, false).withTitle(TraceBundle.message("console.trace.toolbar.loadTrace.fileChooser.title", new Object[0])), null, null);
        final VirtualFile[] files = chooser.choose(null, new VirtualFile[0]);
        if (files.length == 1) {
            final Semaphore semaphore = new Semaphore();
            final TraceLoadedHandler loaded = new TraceLoadedHandler(){

                @Override
                public void traceLoaded(@NotNull String traceId) {
                    if (traceId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceId", "com/intellij/javascript/trace/execution/actions/LoadTraceAction$1", "traceLoaded"));
                    }
                    try {
                        LoadTraceAction.this.myLoaded.run();
                    }
                    finally {
                        semaphore.up();
                    }
                }
            };
            semaphore.down();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(LoadTraceAction.getEventProject((AnActionEvent)e), TraceBundle.message("console.trace.toolbar.loading", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/trace/execution/actions/LoadTraceAction$2", "run"));
                    }
                    indicator.setIndeterminate(true);
                    LoadTraceAction.this.mySession.loadTrace(StringUtil.trimEnd((String)files[0].getPath(), (String)"!/"), loaded);
                    semaphore.waitFor();
                }
            });
        }
    }
}

