/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.diagram;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DefaultUserResponse;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.diagram.PersistenceDiagram;
import com.intellij.persistence.diagram.PersistenceDiagramSupport;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentSuperclass;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDiagramSupport
implements PersistenceDiagramSupport<PersistencePackage, PersistentObject, PersistentAttribute> {
    private Map<PsiClass, PersistentObject> myClassMap;
    private Collection<PersistentObject> myPersistentObjects;
    private final PersistenceFacet myFacet;
    private PersistenceModelBrowser myModelBrowser;

    public DefaultDiagramSupport(PersistenceFacet facet) {
        this.myFacet = facet;
    }

    public PersistenceFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public ModificationTracker getModificationTracker(PersistencePackage unit) {
        return this.myFacet.getModificationTracker();
    }

    @Override
    public void startDataModelUpdate(PersistencePackage persistencePackage) {
        this.myModelBrowser = PersistenceCommonUtil.createFacetAndUnitModelBrowser(this.myFacet, persistencePackage, null);
        if (persistencePackage == null || !persistencePackage.isValid()) {
            this.myPersistentObjects = Collections.emptyList();
            this.myClassMap = Collections.emptyMap();
        } else {
            PersistenceMappings entityMappings = this.myFacet.getEntityMappings(persistencePackage);
            this.startDataModelUpdate(entityMappings);
        }
    }

    @Override
    public void startDataModelUpdate(PersistenceMappings entityMappings) {
        this.myPersistentObjects = PersistenceCommonUtil.queryPersistentObjects(entityMappings).findAll();
        this.myClassMap = new THashMap();
        for (PersistentObject persistentObject : this.myPersistentObjects) {
            PsiClass psiClass = (PsiClass)persistentObject.getClazz().getValue();
            if (psiClass == null) continue;
            this.myClassMap.put(psiClass, persistentObject);
        }
    }

    @Override
    public void finishDataModelUpdate() {
        this.myPersistentObjects = null;
        this.myClassMap = null;
    }

    public PersistenceModelBrowser getModelBrowser() {
        return this.myModelBrowser;
    }

    @Override
    public void processEntities(PairProcessor<? super PersistentObject, String> pairProcessor, boolean superclasses, boolean embeddables) {
        for (PersistentObject object : this.myPersistentObjects) {
            PsiClass psiClass;
            if (!superclasses && object instanceof PersistentSuperclass || !embeddables && object instanceof PersistentEmbeddable || pairProcessor.process((Object)object, (Object)((psiClass = (PsiClass)object.getClazz().getValue()) == null ? object.getClazz().getStringValue() : psiClass.getQualifiedName()))) continue;
            return;
        }
    }

    @Override
    public void processSuper(PersistentObject sourceEntity, PairProcessor<? super PersistentObject, String> pairProcessor) {
        PsiClass psiClass = (PsiClass)sourceEntity.getClazz().getValue();
        if (psiClass == null) {
            return;
        }
        for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass.getSuperClass())) {
            PersistentObject superObject = this.myClassMap.get(curClass);
            if (superObject == null || pairProcessor.process((Object)superObject, (Object)curClass.getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void processRelated(PersistentObject sourceEntity, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : sourceEntity.getObjectModelHelper().getAttributes()) {
            PersistentRelationshipAttribute attribute;
            PsiClass psiClass;
            if (!(persistentAttribute instanceof PersistentRelationshipAttribute) || pairProcessor.process((Object)persistentAttribute, (Object)((psiClass = PersistenceCommonUtil.getTargetClass(attribute = (PersistentRelationshipAttribute)persistentAttribute)) == null ? attribute.getTargetEntityClass().getStringValue() : psiClass.getQualifiedName()))) continue;
            return;
        }
    }

    @Override
    public void processEmbedded(PersistentObject sourceEntity, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : sourceEntity.getObjectModelHelper().getAttributes()) {
            PersistentEmbeddedAttribute attribute;
            PsiClass psiClass;
            if (!(persistentAttribute instanceof PersistentEmbeddedAttribute) || pairProcessor.process((Object)persistentAttribute, (Object)((psiClass = PersistenceCommonUtil.getTargetClass(attribute = (PersistentEmbeddedAttribute)persistentAttribute)) == null ? attribute.getTargetEmbeddableClass().getStringValue() : psiClass.getQualifiedName()))) continue;
            return;
        }
    }

    @Override
    public void processAttributes(PersistentObject persistentObject, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : persistentObject.getObjectModelHelper().getAttributes()) {
            if (persistentAttribute instanceof PersistentTransientAttribute || persistentAttribute instanceof PersistentRelationshipAttribute || persistentAttribute instanceof PersistentEmbeddedAttribute || pairProcessor.process((Object)persistentAttribute, persistentAttribute.getName().getValue())) continue;
            return;
        }
    }

    @Override
    @Nullable
    public PersistentObject getAttributeTarget(PersistentAttribute persistentAttribute) {
        if (persistentAttribute instanceof PersistentRelationshipAttribute) {
            return (PersistentObject)this.myModelBrowser.queryTargetPersistentObjects((PersistentRelationshipAttribute)persistentAttribute).findFirst();
        }
        if (persistentAttribute instanceof PersistentEmbeddedAttribute) {
            return (PersistentObject)this.myModelBrowser.queryTargetPersistentObjects((PersistentEmbeddedAttribute)persistentAttribute).findFirst();
        }
        return null;
    }

    @Override
    public String getUniqueId(PersistentObject persistentObject) {
        return PersistenceCommonUtil.getUniqueId(persistentObject == null ? null : persistentObject.getIdentifyingPsiElement());
    }

    @Override
    @Nullable
    public PersistentAttribute getInverseSideAttribute(PersistentAttribute persistentAttribute) {
        assert (persistentAttribute instanceof PersistentRelationshipAttribute);
        return (PersistentAttribute)this.myModelBrowser.queryTheOtherSideAttributes((PersistentRelationshipAttribute)persistentAttribute, false).findFirst();
    }

    @Override
    @Nullable
    public String getAttributeName(PersistentAttribute persistentAttribute) {
        return (String)persistentAttribute.getName().getValue();
    }

    @Override
    @Nullable
    public PsiType getAttributePsiType(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getPsiType();
    }

    @Override
    @NonNls
    @NotNull
    public String getEntityTypeName(PersistentObject persistentObject) {
        String string = ElementPresentationManager.getTypeNameForObject((Object)persistentObject);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/diagram/DefaultDiagramSupport", "getEntityTypeName"));
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getAttributeTypeName(PersistentAttribute persistentAttribute) {
        String string = ElementPresentationManager.getTypeNameForObject((Object)persistentAttribute);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/diagram/DefaultDiagramSupport", "getAttributeTypeName"));
        }
        return string;
    }

    @Override
    public boolean isIdAttribute(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getAttributeModelHelper().isIdAttribute();
    }

    @Override
    @NotNull
    public String getAttributeMultiplicityLabel(PersistentAttribute first, PersistentAttribute second, boolean isSource) {
        assert (first instanceof PersistentRelationshipAttribute && (second == null || second instanceof PersistentRelationshipAttribute));
        PersistentRelationshipAttribute attribute = (PersistentRelationshipAttribute)first;
        boolean many = attribute.getAttributeModelHelper().getRelationshipType().isMany(isSource);
        boolean optional = attribute.getAttributeModelHelper().isRelationshipSideOptional(isSource) && !this.isNotNull((PersistentRelationshipAttribute)second);
        String string = PersistenceCommonUtil.getMultiplicityString(optional, many);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/diagram/DefaultDiagramSupport", "getAttributeMultiplicityLabel"));
        }
        return string;
    }

    private boolean isNotNull(PersistentRelationshipAttribute attribute) {
        PsiMember owner = attribute == null ? null : attribute.getPsiMember();
        return owner != null && NullableNotNullManager.isNotNull((PsiModifierListOwner)owner);
    }

    @Override
    @Nullable
    public Icon getEntityIcon(PersistentObject persistentObject) {
        return ElementPresentationManager.getIcon((Object)persistentObject);
    }

    @Override
    @Nullable
    public Icon getAttributeIcon(PersistentAttribute persistentAttribute, boolean forceId) {
        return ElementPresentationManager.getIcon((Object)persistentAttribute);
    }

    @Override
    @NotNull
    public TypeSafeDataProvider createDataProvider(final PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        TypeSafeDataProvider typeSafeDataProvider = new TypeSafeDataProvider(){

            public void calcData(DataKey key, DataSink sink) {
                DefaultDiagramSupport.this.getData(diagram, key, sink);
            }
        };
        if (typeSafeDataProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/diagram/DefaultDiagramSupport", "createDataProvider"));
        }
        return typeSafeDataProvider;
    }

    protected boolean getData(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, DataKey key, DataSink sink) {
        boolean set = false;
        if (CommonDataKeys.PROJECT.equals(key)) {
            set = true;
            sink.put(CommonDataKeys.PROJECT, (Object)diagram.getProject());
        } else if (PersistenceDataKeys.PERSISTENCE_FACET.equals((Object)key)) {
            set = true;
            sink.put(PersistenceDataKeys.PERSISTENCE_FACET, (Object)this.myFacet);
        } else if (PersistenceDataKeys.PERSISTENCE_UNIT.equals((Object)key)) {
            set = true;
            sink.put(PersistenceDataKeys.PERSISTENCE_UNIT, (Object)diagram.getUnit());
        } else {
            if (!diagram.getUnit().isValid()) {
                return false;
            }
            if (LangDataKeys.MODULE.equals(key)) {
                set = true;
                sink.put(LangDataKeys.MODULE, (Object)diagram.getUnit().getModule());
            } else if (PersistenceDataKeys.MODEL_ELEMENT_CONTEXT.equals((Object)key)) {
                CommonModelElement element = diagram.getSelectedEntity() != null ? (CommonModelElement)diagram.getSelectedEntity() : (CommonModelElement)diagram.getUnit();
                set = true;
                sink.put(PersistenceDataKeys.MODEL_ELEMENT_CONTEXT, (Object)element);
            } else if (LangDataKeys.PSI_ELEMENT_ARRAY.equals(key)) {
                set = true;
                Collection<CommonModelElement> elements = this.getSelectedElements(diagram);
                if (!elements.isEmpty()) {
                    HashSet result = new HashSet();
                    for (CommonModelElement element : elements) {
                        PsiElement psiElement = element.getIdentifyingPsiElement();
                        ContainerUtil.addIfNotNull((Object)psiElement, result);
                    }
                    sink.put(LangDataKeys.PSI_ELEMENT_ARRAY, (Object)PsiUtilCore.toPsiElementArray(result));
                }
            } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.equals(key)) {
                set = true;
                Collection<CommonModelElement> elements = this.getSelectedElements(diagram);
                if (!elements.isEmpty()) {
                    sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new JamDeleteProvider((JamUserResponse)new DefaultUserResponse(diagram.getProject()), elements));
                }
            } else if (CommonDataKeys.NAVIGATABLE_ARRAY.equals(key)) {
                set = true;
                Collection<CommonModelElement> elements = this.getSelectedElements(diagram);
                if (!elements.isEmpty()) {
                    HashSet<Object> result = new HashSet<Object>();
                    for (CommonModelElement element : elements) {
                        PsiFile containingFile;
                        VirtualFile file;
                        PsiElement psiElement = element.getIdentifyingPsiElement();
                        if (psiElement instanceof Navigatable) {
                            result.add((Navigatable)psiElement);
                            continue;
                        }
                        if (psiElement == null || (file = (containingFile = psiElement.getContainingFile()) == null ? null : containingFile.getVirtualFile()) == null) continue;
                        result.add(new OpenFileDescriptor(psiElement.getProject(), file, psiElement.getTextOffset()));
                    }
                    sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)result.toArray(new Navigatable[result.size()]));
                }
            }
        }
        return set;
    }

    private Collection<CommonModelElement> getSelectedElements(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        HashSet<CommonModelElement> elements = new HashSet<CommonModelElement>();
        diagram.processSelectedNodes((PairProcessor<PersistentObject, String>)((PairProcessor)(persistentObject, persistentAttribute) -> {
            ContainerUtil.addIfNotNull((Object)persistentObject, (Collection)elements);
            return true;
        }));
        diagram.processSelectedEdges((PairProcessor<PersistentObject, PersistentAttribute>)((PairProcessor)(persistentObject, persistentAttribute) -> {
            ContainerUtil.addIfNotNull((Object)persistentAttribute, (Collection)elements);
            if (persistentAttribute instanceof PersistentRelationshipAttribute) {
                elements.addAll(this.myModelBrowser.queryTheOtherSideAttributes((PersistentRelationshipAttribute)persistentAttribute, false).findAll());
            }
            return true;
        }));
        return elements;
    }

    @Override
    public boolean processEditNode(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, PersistentObject entity) {
        return false;
    }

    @Override
    public boolean processEditEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram) {
        return false;
    }

    @Override
    public void processCreateEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram, PersistentObject sourceEntity, PersistentObject targetEntity) {
    }

    @Override
    public void customizeGraphView(Graph2DView view, EditMode editMode) {
    }

    public static void initUpdateListenerOnFacet(final @NotNull GraphBuilder builder, @NotNull Facet facet) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/persistence/diagram/DefaultDiagramSupport", "initUpdateListenerOnFacet"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/persistence/diagram/DefaultDiagramSupport", "initUpdateListenerOnFacet"));
        }
        FacetModificationTrackingService.getInstance((Facet)facet).addModificationTrackerListener(facet, (ModificationTrackerListener)new ModificationTrackerListener<Facet>(){

            public void modificationCountChanged(Facet facet) {
                if (builder.getView().getJComponent().isShowing()) {
                    builder.queueUpdate();
                }
            }
        }, (Disposable)builder);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (builder.getView().getJComponent().isShowing()) {
                    builder.queueUpdate();
                }
            }
        }, (Disposable)builder);
    }
}

