/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.graph;

import com.intellij.psi.PsiElement;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalModelDependency {
    private final LocalModelDependencyType myType;
    private final PsiElement myIdentifyingElement;
    private final String myLabel;

    public static LocalModelDependency create() {
        return new LocalModelDependency("", LocalModelDependencyType.UNKNOWN, null);
    }

    public static LocalModelDependency create(@NotNull LocalModelDependencyType type, @NotNull PsiElement identifyingElement) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "create"));
        }
        if (identifyingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifyingElement", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "create"));
        }
        return new LocalModelDependency(identifyingElement.getText(), type, identifyingElement);
    }

    public static LocalModelDependency create(@NotNull String label, @NotNull LocalModelDependencyType type, @Nullable PsiElement identifyingElement) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "create"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "create"));
        }
        return new LocalModelDependency(label, type, identifyingElement);
    }

    private LocalModelDependency(@NotNull String label, @NotNull LocalModelDependencyType type, @Nullable PsiElement identifyingElement) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "<init>"));
        }
        this.myLabel = label;
        this.myType = type;
        this.myIdentifyingElement = identifyingElement;
    }

    @NotNull
    public LocalModelDependencyType getType() {
        LocalModelDependencyType localModelDependencyType = this.myType;
        if (localModelDependencyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/graph/LocalModelDependency", "getType"));
        }
        return localModelDependencyType;
    }

    @Nullable
    public PsiElement getIdentifyingElement() {
        return this.myIdentifyingElement;
    }

    public String toString() {
        return "LocalModelDependency{" + (Object)((Object)this.myType) + ", " + this.myIdentifyingElement + '}';
    }

    public String getLabel() {
        return this.myLabel;
    }
}

