/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.web.WebUtil;
import com.intellij.lang.jsp.JspFileViewProvider;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.jsp.WebDirectoryElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultJ2EEContainerExtension
extends JavaCoverageEngineExtension {
    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        return conf instanceof CommonModel && ((CommonModel)conf).isLocal();
    }

    public boolean suggestQualifiedName(@NotNull PsiFile sourceFile, PsiClass[] classes, Set<String> names) {
        WebDirectoryElement webDirectoryElement;
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/coverage/DefaultJ2EEContainerExtension", "suggestQualifiedName"));
        }
        FileViewProvider viewProvider = sourceFile.getViewProvider();
        if (!(viewProvider instanceof JspFileViewProvider) && !(viewProvider instanceof JspxFileViewProvider)) {
            return false;
        }
        VirtualFile virtualFile = sourceFile.getVirtualFile();
        if (virtualFile != null && (webDirectoryElement = WebUtil.findWebDirectoryByFile((VirtualFile)virtualFile, (Project)sourceFile.getProject())) != null) {
            String webRoot;
            WebDirectoryElement parentDirectory = webDirectoryElement.getParentDirectory();
            String string = webRoot = parentDirectory != null ? parentDirectory.getPath() : "/";
            if (!webRoot.endsWith("/")) {
                webRoot = webRoot + "/";
            }
            names.add("org.apache.jsp" + DefaultJ2EEContainerExtension.makeJavaIdentifier(webRoot + virtualFile.getName(), sourceFile.getProject()));
            return true;
        }
        return false;
    }

    public static String makeJavaIdentifier(String identifier, Project project) {
        StringBuffer modifiedIdentifier = new StringBuffer(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0)) && identifier.charAt(0) != '/') {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (ch == '/') {
                modifiedIdentifier.append('.');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(DefaultJ2EEContainerExtension.mangleChar(ch));
        }
        if (PsiNameHelper.getInstance((Project)project).isKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    public static String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }
}

