/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web;

import com.intellij.facet.FacetConfiguration;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebModelBase;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfigurationImpl;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.impl.source.jsp.impl.WebDirectoryElementImpl;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebUtilImpl
extends WebUtil {
    public static boolean isWebFacetConfigurationContainingFiles(FacetConfiguration configuration, Set<VirtualFile> files) {
        if (!(configuration instanceof WebFacetConfigurationImpl)) {
            return false;
        }
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem(files);
        if (file == null) {
            return false;
        }
        WebFacetConfigurationImpl webConfiguration = (WebFacetConfigurationImpl)configuration;
        return WebUtilImpl.isInsideWebRootsInternal(file, webConfiguration.getWebRoots()) || WebUtilImpl.isUnderSourceRoots(file, webConfiguration.getSourceRoots());
    }

    private static boolean isInsideWebRootsInternal(VirtualFile source, List<WebRootData> webRoots) {
        for (WebRootData webRoot : webRoots) {
            VirtualFile root = webRoot.findFile();
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)source, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public WebDirectoryElement createWebDirectoryElement(WebFacet webFacet, @NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/j2ee/web/WebUtilImpl", "createWebDirectoryElement"));
        }
        return new WebDirectoryElementImpl(webFacet, path, isDirectory);
    }

    public WebModel getLocalWebModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/j2ee/web/WebUtilImpl", "getLocalWebModel"));
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        final DomFileElement element = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, WebApp.class);
        return element == null ? null : new WebModelBase(){

            @Override
            @NotNull
            protected Module getModule() {
                Module module2 = module;
                if (module2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/WebUtilImpl$1", "getModule"));
                }
                return module2;
            }

            @Override
            protected Collection<WebApp> getApps() {
                return Collections.singleton(element.getRootElement());
            }
        };
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryByFile(@NotNull VirtualFile file, @NotNull WebFacet webFacet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/j2ee/web/WebUtilImpl", "findWebDirectoryByFile"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/j2ee/web/WebUtilImpl", "findWebDirectoryByFile"));
        }
        return WebDirectoryUtil.getWebDirectoryUtil(webFacet.getModule().getProject()).findWebDirectoryByFile(file, webFacet);
    }

    @Nullable
    public JspFile getJspFile(Servlet servlet) {
        String jspFileName = (String)servlet.getJspFile().getValue();
        if (jspFileName == null) {
            return null;
        }
        WebFacet webFacet = WebUtilImpl.getWebFacet((JavaeeModelElement)servlet);
        if (webFacet == null) {
            return null;
        }
        WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil(webFacet.getModule().getProject());
        PsiFileSystemItem psiElement = webDirectoryUtil.findFileByPath(jspFileName, webFacet);
        if (psiElement == null) {
            return null;
        }
        return JspPsiUtil.getJspFile((PsiElement)psiElement);
    }

    private static boolean isUnderSourceRoots(VirtualFile file, List<String> urls) {
        for (String url : urls) {
            VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(url);
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ServletMappingInfo resolveServletMappingInfo(@NotNull String url, @NotNull WebFacet webFacet) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/j2ee/web/WebUtilImpl", "resolveServletMappingInfo"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/j2ee/web/WebUtilImpl", "resolveServletMappingInfo"));
        }
        ServletMappingInfo result = null;
        int urlLength = url.length();
        for (CommonServletMapping mapping : webFacet.getWebModel().getServletMappings()) {
            for (GenericValue value : mapping.getUrlPatterns()) {
                String urlPattern = (String)value.getValue();
                if (urlPattern == null) continue;
                ServletMappingType patternType = ServletMappingType.getPatternType((String)urlPattern);
                switch (patternType) {
                    case EXACT: {
                        if (!url.equals(urlPattern) && (!urlPattern.startsWith("/") || !urlPattern.substring(1).equals(url))) break;
                        return patternType.createMappingInfo(urlPattern, mapping);
                    }
                    case EXTENSION: {
                        int patternLength = urlPattern.length();
                        if (urlLength < patternLength || !url.regionMatches(urlLength - patternLength + 1, urlPattern, 1, patternLength - 1) || result != null && urlPattern.length() <= result.getUrlPattern().length()) break;
                        result = patternType.createMappingInfo(urlPattern, mapping);
                        break;
                    }
                    case PATH: {
                        int urlOffset;
                        int n = urlOffset = url.startsWith("/") ? 1 : 0;
                        if (!url.regionMatches(urlOffset, urlPattern, 1, urlPattern.length() - 2) || result != null && urlPattern.length() <= result.getUrlPattern().length()) break;
                        result = patternType.createMappingInfo(urlPattern, mapping);
                        break;
                    }
                    case DEFAULT: {
                        if (result != null) break;
                        result = patternType.createMappingInfo(urlPattern, mapping);
                    }
                }
            }
        }
        return result;
    }

    @Nullable
    public WebDirectoryElement getParentWebDirectory(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/j2ee/web/WebUtilImpl", "getParentWebDirectory"));
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return WebDirectoryUtil.findParentWebDirectory(file.getProject(), virtualFile);
    }

    @Nullable
    public WebDirectoryElement getContainingWebDirectory(JspxFileViewProvider viewProvider) {
        if (!viewProvider.isPhysical()) {
            return null;
        }
        return WebDirectoryUtil.findParentWebDirectory(viewProvider.getManager().getProject(), viewProvider.getVirtualFile());
    }

    @Nullable
    public String getWebPath(PsiFile file) {
        WebDirectoryElement parent = this.getParentWebDirectory(file);
        if (parent != null) {
            String parentPath = parent.getPath();
            return parentPath.endsWith("/") ? parentPath + file.getName() : parentPath + "/" + file.getName();
        }
        return null;
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryElement(@NotNull @NonNls String path, @NotNull WebFacet facet) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/j2ee/web/WebUtilImpl", "findWebDirectoryElement"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/j2ee/web/WebUtilImpl", "findWebDirectoryElement"));
        }
        return WebDirectoryUtil.resolveAbsolutePath(path, facet);
    }

    public void visitAllFacets(@NotNull Module thisModule, Consumer<WebFacet> visitor) {
        if (thisModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisModule", "com/intellij/j2ee/web/WebUtilImpl", "visitAllFacets"));
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        Object[] dependencies = moduleRootManager.getDependencies();
        ArrayList<Module> modules = new ArrayList<Module>(dependencies.length + 1);
        modules.add(thisModule);
        ContainerUtil.addAll(modules, (Object[])dependencies);
        for (Module module : modules) {
            Collection facets = WebFacet.getInstances((Module)module);
            for (WebFacet facet : facets) {
                visitor.consume((Object)facet);
            }
        }
    }

    public Collection<PsiFileSystemItem> getContextsByPath(String path, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/j2ee/web/WebUtilImpl", "getContextsByPath"));
        }
        ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
        WebUtil.getWebUtil().visitAllFacets(module, webFacet -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/j2ee/web/WebUtilImpl", "lambda$getContextsByPath$0"));
            }
            WebDirectoryElement element = WebDirectoryUtil.getWebDirectoryUtil(module.getProject()).findWebDirectoryElementByPath(path, (WebFacet)webFacet);
            if (element != null) {
                list.add((PsiFileSystemItem)element);
            }
        });
        return list;
    }
}

