/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SecurityRoleNameInspection
extends BasicDomElementsInspection<JavaeeDomModelElement> {
    private static final ElementPattern ROLE_NAME_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{StandardPatterns.character().javaIdentifierPart(), StandardPatterns.character().oneOf((Object[])new Character[]{Character.valueOf('.'), Character.valueOf('-')})});

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        SecurityRole securityRole;
        GenericDomValue nameValue;
        XmlTag tag;
        if (element instanceof SecurityRole && (tag = (nameValue = (securityRole = (SecurityRole)element).getRoleName()).getXmlTag()) != null) {
            String text = nameValue.getStringValue();
            for (int i = 0; i < text.length(); ++i) {
                if (ROLE_NAME_PATTERN.accepts((Object)Character.valueOf(text.charAt(i)))) continue;
                holder.createProblem((DomElement)nameValue, HighlightSeverity.ERROR, J2EEBundle.message((String)"security.role.name.should.accord.to.nmtoken.pattern", (Object[])new Object[0]));
                return;
            }
        }
    }

    public SecurityRoleNameInspection() {
        super(JavaeeApplication.class, new Class[]{EjbJar.class, WebApp.class});
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.JAVAEE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/SecurityRoleNameInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = J2EEBundle.message((String)"inspection.javaee.xml.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/SecurityRoleNameInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SecurityRoles" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/SecurityRoleNameInspection", "getShortName"));
        }
        return "SecurityRoles";
    }
}

