/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfiguration;
import com.intellij.javaee.ejb.facet.EjbFacetConfigurationImpl;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.ejb.framework.EjbFrameworkType;
import com.intellij.javaee.framework.JavaeeFrameworkDetector;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EjbFrameworkDetector
extends JavaeeFrameworkDetector<EjbFacet, EjbFacetConfiguration> {
    public EjbFrameworkDetector() {
        super("ejb");
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName(EjbRootDescriptor.EJB_JAR_META_DATA.getFileName()).xmlWithRootTag("ejb-jar");
        if (fileContentPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/framework/EjbFrameworkDetector", "createSuitableFilePattern"));
        }
        return fileContentPattern;
    }

    public void setupFacet(@NotNull EjbFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/ejb/framework/EjbFrameworkDetector", "setupFacet"));
        }
        List<String> sourceRoots = Arrays.asList(model.getSourceRootUrls(false));
        ((EjbFacetConfigurationImpl)facet.getConfiguration()).setSourceRoots(new ArrayList<String>(sourceRoots));
    }

    @Override
    public EjbFacetType getFacetType() {
        return EjbFacetType.getInstance();
    }

    public FrameworkType getFrameworkType() {
        return EjbFrameworkType.getInstance();
    }
}

