/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.managedbean.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.inspections.EjbHighlightUtil;
import com.intellij.javaee.managedbean.ManagedBeanService;
import com.intellij.javaee.model.common.managedbean.ManagedBean;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ManagedBeanClassInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.JAVAEE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Managed Bean Class Inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection", "getDisplayName"));
        }
        return "Managed Bean Class Inspection";
    }

    @NotNull
    public String getShortName() {
        if ("ManagedBeanClassInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection", "getShortName"));
        }
        return "ManagedBeanClassInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javaee/managedbean/inspections/ManagedBeanClassInspection", "checkClass"));
        }
        ManagedBean bean = ManagedBeanService.getInstance((Project)aClass.getProject()).getManagedBean(aClass);
        if (bean == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
        EjbHighlightUtil.checkClassIsInterface(holder, aClass, false);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "final", false);
        EjbHighlightUtil.checkClassModifier(holder, aClass, "abstract", false);
        if (aClass.getContainingClass() != null) {
            EjbHighlightUtil.checkClassModifier(holder, aClass, "static", true);
        }
        return holder.getResultsArray();
    }
}

