/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.execution.update.FilteredByFileTypeCompileScope;
import com.intellij.javaee.run.execution.update.UpdateResourcesBuildContributor;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.ResourcesTargetType;

public class ReloadResourcesUpdatingPolicy
extends UpdatingPolicy {
    private static final Logger LOG = Logger.getInstance(ReloadResourcesUpdatingPolicy.class);
    @NonNls
    private static final String ID = "update-resources";

    public static UpdatingPolicy getInstance() {
        return UpdatingRunningApplicationUtil.findPolicy(ID);
    }

    public ReloadResourcesUpdatingPolicy() {
        super(ID);
    }

    @Override
    public String getDescription() {
        return J2EEBundle.message((String)"updating.policy.update.resources", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailableOnFrameDeactivation() {
        return true;
    }

    @Override
    public boolean isAvailableForConfiguration(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy", "isAvailableForConfiguration"));
        }
        return UpdatingRunningApplicationUtil.isResourcesReloadingSupported(commonModel);
    }

    @Override
    public void runUpdate(@NotNull Project project, @Nullable Executor executor, @NotNull J2EEServerInstance serverInstance, @NotNull ProcessHandler processHandler, boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy", "runUpdate"));
        }
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy", "runUpdate"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy", "runUpdate"));
        }
        List artifacts = serverInstance.getCommonModel().getDeployedArtifacts();
        CompileScope scope = ReloadResourcesUpdatingPolicy.createCompileScope(project, artifacts);
        UpdatingRunningApplicationUtil.updateOpenedFilesAndStartCompilation(project, artifacts, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy", "lambda$runUpdate$0"));
            }
            if (serverInstance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy", "lambda$runUpdate$0"));
            }
            UpdatingRunningApplicationUtil.startCompilation(project, scope, new UpdateResourceOnServerListener(serverInstance, false), CompilerFilter.ALL, onFrameDeactivation);
        });
    }

    static CompileScope createCompileScope(Project project, List<Artifact> artifacts) {
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, (Project)project);
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (Module module : modules) {
            moduleNames.add(module.getName());
        }
        ModuleCompileScope modulesScope = new ModuleCompileScope(project, modules.toArray(new Module[modules.size()]), true);
        CompileScope scopeWithArtifacts = ArtifactCompileScope.createScopeWithArtifacts((CompileScope)new FilteredByFileTypeCompileScope((CompileScope)modulesScope, new FileType[]{StdFileTypes.JAVA}), artifacts);
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> resourceScopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        resourceScopes.add(CmdlineProtoUtil.createTargetsScope((String)ResourcesTargetType.PRODUCTION.getTypeId(), moduleNames, (boolean)false));
        resourceScopes.add(CmdlineProtoUtil.createTargetsScope((String)ResourcesTargetType.TEST.getTypeId(), moduleNames, (boolean)false));
        for (UpdateResourcesBuildContributor provider : (UpdateResourcesBuildContributor[])UpdateResourcesBuildContributor.EP_NAME.getExtensions((AreaInstance)project)) {
            for (BuildTargetType buildTargetType : provider.getResourceTargetTypes()) {
                resourceScopes.add(CmdlineProtoUtil.createTargetsScope((String)buildTargetType.getTypeId(), moduleNames, (boolean)false));
            }
        }
        CompileScopeUtil.setBaseScopeForExternalBuild((CompileScope)scopeWithArtifacts, resourceScopes);
        return scopeWithArtifacts;
    }

    public static class UpdateResourceOnServerListener
    implements CompileStatusNotification {
        private final J2EEServerInstance myServerInstance;
        private boolean myUpdateClassFiles;

        public UpdateResourceOnServerListener(J2EEServerInstance serverInstance, boolean updateClassFiles) {
            this.myServerInstance = serverInstance;
            this.myUpdateClassFiles = updateClassFiles;
        }

        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            Set writtenPaths;
            if (!aborted && errors == 0 && (writtenPaths = ArtifactsCompiler.getWrittenPaths((CompileContext)compileContext)) != null && this.myServerInstance instanceof DefaultServerInstance) {
                Set toUpdate;
                if (this.myUpdateClassFiles) {
                    toUpdate = writtenPaths;
                } else {
                    THashSet withoutClassFiles = new THashSet();
                    for (String path : writtenPaths) {
                        if (path.endsWith(".class")) continue;
                        withoutClassFiles.add(path);
                    }
                    toUpdate = withoutClassFiles;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating changed files on server '" + this.myServerInstance.getName() + "' (" + toUpdate.size() + "): ");
                    for (String path : toUpdate) {
                        LOG.debug(path);
                    }
                }
                ((DefaultServerInstance)this.myServerInstance).updateChangedFiles(toUpdate);
            }
        }
    }
}

