/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebContextConfigurable
extends LanguagePerFileConfigurable<String> {
    public WebContextConfigurable(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/web/WebContextConfigurable", "<init>"));
        }
        super(project, String.class, (PerFileMappings)new PerFileMappings<String>(){

            @NotNull
            public Map<VirtualFile, String> getMappings() {
                Map map = WebContextManager.getInstance((Project)project).getMappings();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/WebContextConfigurable$1", "getMappings"));
                }
                return map;
            }

            public void setMappings(@NotNull Map<VirtualFile, String> mappings) {
                if (mappings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/javaee/web/WebContextConfigurable$1", "setMappings"));
                }
                WebContextManager.getInstance((Project)project).setMappings(mappings);
            }

            public void setMapping(VirtualFile file, String value) {
                throw new UnsupportedOperationException();
            }

            public Collection<String> getAvailableValues(VirtualFile file) {
                WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project);
                if (webFacet != null) {
                    VirtualFile virtualFile;
                    Collection items;
                    VirtualFile originalVirtualFile;
                    WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement("/", webFacet);
                    if (element != null && (originalVirtualFile = element.getOriginalVirtualFile()) != null) {
                        return Collections.singletonList(originalVirtualFile.getUrl());
                    }
                    Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                    if (module != null && !(items = WebUtil.getWebUtil().getContextsByPath("/", module)).isEmpty() && (virtualFile = ((PsiFileSystemItem)items.iterator().next()).getVirtualFile()) != null) {
                        return Collections.singletonList(virtualFile.getUrl());
                    }
                }
                return Collections.emptyList();
            }

            public String getDefaultMapping(@Nullable VirtualFile file) {
                return null;
            }

            @Nullable
            public String getMapping(VirtualFile file) {
                Map<VirtualFile, String> mappings = this.getMappings();
                for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
                    String s = mappings.get(cur);
                    if (s == null) continue;
                    return s;
                }
                return null;
            }

            public String chosenToStored(VirtualFile file, String value) {
                return value;
            }

            public boolean isSelectable(String value) {
                return true;
            }
        }, WebBundle.message("web.contexts.caption", ApplicationNamesInfo.getInstance().getProductName()), WebBundle.message("web.context", new Object[0]), "There are web contexts specified for the subdirectories. Override them?", "Override Web Contexts");
    }

    public JComponent createComponent() {
        JComponent jComponent = super.createComponent();
        AbstractFileTreeTable treeView = this.getTreeView();
        treeView.setRootVisible(false);
        ((DefaultTreeModel)treeView.getTableModel()).setRoot((TreeNode)new AbstractFileTreeTable.ProjectRootNode(this.myProject){

            protected void appendChildrenTo(@NotNull Collection<AbstractFileTreeTable.ConvenientNode> children) {
                if (children == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javaee/web/WebContextConfigurable$2", "appendChildrenTo"));
                }
                for (Module module : ModuleManager.getInstance((Project)WebContextConfigurable.this.myProject).getModules()) {
                    for (WebFacet facet : WebFacet.getInstances((Module)module)) {
                        for (WebRoot root : facet.getWebRoots()) {
                            VirtualFile file = root.getFile();
                            if (file == null) continue;
                            children.add((AbstractFileTreeTable.ConvenientNode)new AbstractFileTreeTable.FileNode(file, WebContextConfigurable.this.myProject));
                        }
                    }
                }
            }
        });
        treeView.getEmptyText().setText(WebBundle.message("web.contexts.no.contexts", new Object[0]));
        return jComponent;
    }

    @Nls
    public String getDisplayName() {
        return WebBundle.message("web.contexts", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.project.settings.webcontexts";
    }

    protected String visualize(@NotNull String s) {
        WebDirectoryElement element;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javaee/web/WebContextConfigurable", "visualize"));
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(s);
        if (file != null && (element = WebUtil.findWebDirectoryByFile((VirtualFile)file, (Project)this.myProject)) != null) {
            return element.getPath();
        }
        return "";
    }
}

