/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.database.model.RawConnectionConfig;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.mapping.EntityMappings;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.manipulators.AbstractPersistenceAction;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JpaUnitManipulator
extends AbstractPersistenceManipulator<PersistenceUnit>
implements PersistenceUnitManipulator<PersistenceUnit> {
    public JpaUnitManipulator(PersistenceUnit target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        return JpaUnitManipulator.getCreateActionsDefault(this, new ArrayList<PersistenceAction>());
    }

    public static List<PersistenceAction> getCreateActionsDefault(PersistenceUnitManipulator<?> unitManipulator, List<PersistenceAction> result) {
        PersistencePackage unit = (PersistencePackage)unitManipulator.getManipulatorTarget();
        List facets = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets(unit);
        result.add((PersistenceAction)new MyMappingsAction(unitManipulator, JpaMessages.message((String)"action.name.create.persistence.mappings", (Object[])new Object[0]), JpaMessages.message((String)"model.object.type.persistence.mappings", (Object[])new Object[0]), JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA.getDefaultVersion().getTemplateName(), EntityMappings.class));
        for (PersistenceFacet facet : facets) {
            PersistenceMappings mappings = facet.getEntityMappings(unit);
            PersistenceManipulator manipulator = PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)mappings, PersistenceManipulator.class);
            if (manipulator == null) continue;
            result.addAll(manipulator.getCreateActions());
        }
        return result;
    }

    public void ensureMappingIncluded(PersistenceMappings mappings) {
        JpaUtil.ensureMappingsIncluded((PersistenceUnit)this.getManipulatorTarget(), mappings);
    }

    public void ensureClassIncluded(PsiClass psiClass) {
        JpaUtil.ensureClassIncluded((PersistenceUnit)this.getManipulatorTarget(), null, psiClass);
    }

    public void setConnectionProperties(@NotNull Project project, @NotNull RawConnectionConfig info, @NotNull Pair<String, String> credentials) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/model/manipulators/JpaUnitManipulator", "setConnectionProperties"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/jpa/model/manipulators/JpaUnitManipulator", "setConnectionProperties"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/jpa/model/manipulators/JpaUnitManipulator", "setConnectionProperties"));
        }
        PersistenceUnit unit = (PersistenceUnit)this.getManipulatorTarget();
        JpaImplementationProvider configuredProvider = JpaUtil.findJpaProvider(null, (PersistencePackage)unit, true);
        if (configuredProvider != null) {
            configuredProvider.setConnectionProperties(project, unit, info, credentials);
        } else {
            for (JpaImplementationProvider provider : (JpaImplementationProvider[])Extensions.getExtensions((ExtensionPointName)JpaImplementationProvider.EP_NAME)) {
                provider.setConnectionProperties(project, unit, info, credentials);
            }
        }
    }

    public static class MyMappingsAction
    extends AbstractPersistenceAction<PersistenceUnitManipulator> {
        private PersistenceFacet myFacet;
        private PersistencePackage myUnit;
        private Collection<PsiFile> myTargetFiles;
        private final String myTemplate;
        private final Class<? extends PersistenceMappings> myMappingsClass;

        public MyMappingsAction(PersistenceUnitManipulator manipulator, String name, String title, String template, Class<? extends PersistenceMappings> mappingsClass) {
            super((PersistenceManipulator)manipulator, name, title, StdFileTypes.XML.getIcon());
            this.myTemplate = template;
            this.myMappingsClass = mappingsClass;
        }

        public int getGroupId() {
            return 20;
        }

        public void update(AnActionEvent e) {
            this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
            this.myUnit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(e.getDataContext());
            this.getPresentation().setEnabled(this.myFacet != null && this.myUnit != null && !JamCommonUtil.isInLibrary((CommonModelElement)this.myUnit));
        }

        public boolean preInvoke(UserResponse response) {
            Object[] files = response.getPersistenceMappingFiles(this.myFacet, this.myTemplate, this.myMappingsClass);
            this.myTargetFiles = ContainerUtil.mapNotNull((Object[])files, virtualFile -> PsiManager.getInstance((Project)this.myFacet.getModule().getProject()).findFile(virtualFile));
            return !this.myTargetFiles.isEmpty();
        }

        protected PsiElement getTargetElement() {
            List currentFiles = this.myUnit.getModelHelper().getMappingFiles(this.myMappingsClass);
            for (PsiFile file : this.myTargetFiles) {
                PersistenceMappings element = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)file, this.myMappingsClass, (Module)this.myFacet.getModule());
                if (element == null || GenericValueUtil.containsValue((Collection)currentFiles, (Object)element)) continue;
                return this.myUnit.getIdentifyingPsiElement();
            }
            return null;
        }

        public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
            if (affectedElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedElements", "com/intellij/jpa/model/manipulators/JpaUnitManipulator$MyMappingsAction", "addAffectedElements"));
            }
            affectedElements.add((PsiElement)this.myUnit.getContainingFile());
        }

        public void invokeAction(@NotNull Collection<PsiElement> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/model/manipulators/JpaUnitManipulator$MyMappingsAction", "invokeAction"));
            }
            PersistenceUnitManipulator manipulator = (PersistenceUnitManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)this.myUnit, PersistenceUnitManipulator.class);
            if (manipulator == null) {
                return;
            }
            for (PsiFile file : this.myTargetFiles) {
                PersistenceMappings element = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)file, this.myMappingsClass, (Module)this.myFacet.getModule());
                if (element == null) continue;
                result.add(element.getIdentifyingPsiElement());
                manipulator.ensureMappingIncluded(element);
            }
        }
    }
}

