/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.EjbRelation;
import com.intellij.javaee.model.xml.ejb.Interceptor;
import com.intellij.javaee.model.xml.ejb.MethodContainer;
import com.intellij.javaee.model.xml.ejb.Relationships;
import com.intellij.javaee.module.view.ejb.permissions.MethodContainerHelper;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;

public class EjbDeleteHandler
extends JamDeleteHandler {
    public void addModelElements(CommonModelElement element, Collection<CommonModelElement> result) {
        if (element instanceof EnterpriseBean) {
            EjbJar root;
            EnterpriseBean ejb = (EnterpriseBean)element;
            EjbFacet ejbFacet = EjbUtil.getEjbFacet((JavaeeModelElement)ejb);
            if (ejbFacet != null && (root = ejbFacet.getXmlRoot()) != null) {
                String name = (String)ejb.getEjbName().getValue();
                AssemblyDescriptor descriptor = root.getAssemblyDescriptor();
                result.addAll(new MethodContainerHelper.MethodPermissionHelper(descriptor).getEjbAttributes(ejb));
                result.addAll(new MethodContainerHelper.ContainerTransactionHelper(descriptor).getEjbAttributes(ejb));
                result.addAll(new MethodContainerHelper.ExcludeListHelper(descriptor.getExcludeList()).getEjbAttributes(ejb));
                result.addAll(ContainerUtil.findAll((Collection)descriptor.getInterceptorBindings(), binding -> Comparing.equal((String)name, (String)binding.getEnterpriseBean().getStringValue())));
                Relationships relationships = root.getRelationships();
                for (EjbRelation relation : relationships.getEjbRelations()) {
                    if (!Comparing.equal((String)name, (String)relation.getEjbRelationshipRole1().getRelationshipRoleSource().getEntityBean().getStringValue()) && !Comparing.equal((String)name, (String)relation.getEjbRelationshipRole2().getRelationshipRoleSource().getEntityBean().getStringValue())) continue;
                    result.add((CommonModelElement)relation);
                }
            }
        } else if (element instanceof SecurityRole) {
            EjbJar ejbJar;
            SecurityRole role = (SecurityRole)element;
            EjbFacet facet = EjbUtil.getEjbFacet((JavaeeModelElement)role);
            if (facet != null && (ejbJar = facet.getXmlRoot()) != null) {
                result.addAll(ContainerUtil.findAll((Collection)ejbJar.getAssemblyDescriptor().getMethodPermissions(), methodPermission -> MethodContainerHelper.containsRoleWithName(methodPermission, (String)role.getRoleName().getValue())));
            }
        } else if (element instanceof com.intellij.javaee.model.common.ejb.Interceptor) {
            EjbJar ejbJar;
            com.intellij.javaee.model.common.ejb.Interceptor interceptor = (com.intellij.javaee.model.common.ejb.Interceptor)element;
            String name = interceptor.getInterceptorClass().getStringValue();
            EjbFacet ejbFacet = EjbUtil.getEjbFacet((JavaeeModelElement)interceptor);
            if (ejbFacet != null && (ejbJar = ejbFacet.getXmlRoot()) != null) {
                result.addAll(ContainerUtil.findAll((Collection)ejbJar.getAssemblyDescriptor().getInterceptorBindings(), binding -> {
                    for (GenericDomValue value : binding.getInterceptorClasses()) {
                        if (!Comparing.equal((String)value.getStringValue(), (String)name)) continue;
                        return true;
                    }
                    return false;
                }));
            }
        }
    }

    public void addPsiElements(CommonModelElement element, Collection<PsiElement> result) {
        if (element instanceof CmpField) {
            CmpField cmpField = (CmpField)element;
            result.addAll(EjbUtil.collectFieldAccessors(cmpField));
            com.intellij.javaee.model.xml.ejb.EntityBean ejb = (com.intellij.javaee.model.xml.ejb.EntityBean)CommonModelManager.getInstance().getDomElement((CommonModelElement)cmpField.getEntityBean());
            if (ejb != null) {
                PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
                int pkFieldCount = EjbUtil.getPkFields((EntityBean)ejb).size();
                if (pkClass != null && EjbUtil.isPK(cmpField)) {
                    if (pkFieldCount == 1) {
                        ContainerUtil.addIfNotNull((Object)ejb.getPrimkeyField().getXmlElement(), result);
                    } else {
                        ContainerUtil.addIfNotNull((Object)pkClass.findFieldByName((String)cmpField.getFieldName().getValue(), false), result);
                    }
                }
            }
        } else if (element instanceof CmrField) {
            result.addAll(EjbUtil.collectFieldAccessors((CmrField)element));
        } else if (element instanceof EjbRelation) {
            EjbRelation relation = (EjbRelation)element;
            List<PsiElement> list = EjbUtil.collectFieldAccessors((CmrField)relation.getEjbRelationshipRole1().getCmrField());
            list.addAll(EjbUtil.collectFieldAccessors((CmrField)relation.getEjbRelationshipRole2().getCmrField()));
        } else if (element instanceof EnterpriseBean) {
            for (PsiClass psiClass : EjbCommonModelUtil.getEjbClasses((EnterpriseBean)((EnterpriseBean)element), (boolean)true, (boolean)true, (boolean)true)) {
                result.add((PsiElement)psiClass);
            }
        } else if (element instanceof Interceptor) {
            ContainerUtil.addIfNotNull((Object)((Interceptor)element).getInterceptorClass().getValue(), result);
        }
    }

    public boolean onChildrenDelete(DomElement element) {
        if (element instanceof MethodContainer) {
            if (((MethodContainer)element).getMethods().isEmpty()) {
                element.undefine();
                return true;
            }
        } else if (element instanceof Relationships && ((Relationships)element).getEjbRelations().isEmpty()) {
            element.undefine();
            return true;
        }
        return false;
    }

    public boolean onChildrenDelete(PsiElement psiElement) {
        return false;
    }
}

