/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitRefManager
implements VcsLogRefManager {
    public static final VcsRefType HEAD = new SimpleRefType(true, VcsLogStandardColors.Refs.TIP, "HEAD");
    public static final VcsRefType LOCAL_BRANCH = new SimpleRefType(true, VcsLogStandardColors.Refs.BRANCH, "LOCAL_BRANCH");
    public static final VcsRefType REMOTE_BRANCH = new SimpleRefType(true, VcsLogStandardColors.Refs.BRANCH_REF, "REMOTE_BRANCH");
    public static final VcsRefType TAG = new SimpleRefType(false, VcsLogStandardColors.Refs.TAG, "TAG");
    public static final VcsRefType OTHER = new SimpleRefType(false, VcsLogStandardColors.Refs.TAG, "OTHER");
    private static final String MASTER = "master";
    private static final String ORIGIN_MASTER = "origin/master";
    private static final Logger LOG = Logger.getInstance(GitRefManager.class);
    @NotNull
    private final RepositoryManager<GitRepository> myRepositoryManager;
    @NotNull
    private final Comparator<VcsRef> myLabelsComparator;
    @NotNull
    private final Comparator<VcsRef> myBranchLayoutComparator;

    public GitRefManager(@NotNull RepositoryManager<GitRepository> repositoryManager) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager", "<init>"));
        }
        this.myRepositoryManager = repositoryManager;
        this.myBranchLayoutComparator = new GitBranchLayoutComparator(repositoryManager);
        this.myLabelsComparator = new GitLabelComparator(repositoryManager);
    }

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        Comparator<VcsRef> comparator = this.myLabelsComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getLabelsOrderComparator"));
        }
        return comparator;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        Comparator<VcsRef> comparator = this.myBranchLayoutComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getBranchLayoutComparator"));
        }
        return comparator;
    }

    @NotNull
    public List<RefGroup> group(Collection<VcsRef> refs) {
        ArrayList simpleGroups = ContainerUtil.newArrayList();
        ArrayList localBranches = ContainerUtil.newArrayList();
        ArrayList trackedBranches = ContainerUtil.newArrayList();
        MultiMap remoteRefGroups = MultiMap.create();
        MultiMap<VirtualFile, VcsRef> refsByRoot = GitRefManager.groupRefsByRoot(refs);
        for (Map.Entry entry : refsByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List refsInRoot = ContainerUtil.sorted((Collection)((Collection)entry.getValue()), this.myLabelsComparator);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.warn("No repository for root: " + root);
                continue;
            }
            Set<String> locals = GitRefManager.getLocalBranches(repository);
            Set<String> tracked = GitRefManager.getTrackedRemoteBranches(repository);
            Map<String, GitRemote> allRemote = GitRefManager.getAllRemoteBranches(repository);
            for (VcsRef ref : refsInRoot) {
                if (ref.getType() == HEAD) {
                    simpleGroups.add(new SingletonRefGroup(ref));
                    continue;
                }
                String refName = ref.getName();
                if (locals.contains(refName)) {
                    localBranches.add(ref);
                    continue;
                }
                if (allRemote.containsKey(refName)) {
                    if (tracked.contains(refName)) {
                        trackedBranches.add(ref);
                        continue;
                    }
                    remoteRefGroups.putValue((Object)allRemote.get(refName), (Object)ref);
                    continue;
                }
                LOG.debug("Didn't find ref neither in local nor in remote branches: " + ref);
            }
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(simpleGroups);
        if (!localBranches.isEmpty()) {
            result.add(new LogicalRefGroup("Local", localBranches));
        }
        if (!trackedBranches.isEmpty()) {
            result.add(new LogicalRefGroup("Tracked", trackedBranches));
        }
        for (Map.Entry entry : remoteRefGroups.entrySet()) {
            GitRemote remote = (GitRemote)entry.getKey();
            Collection branches = (Collection)entry.getValue();
            result.add(new RemoteRefGroup(remote, branches));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "group"));
        }
        return arrayList;
    }

    private static Set<String> getLocalBranches(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranches().getLocalBranches(), (Function)new Function<GitBranch, String>(){

            public String fun(GitBranch branch) {
                return branch.getName();
            }
        });
    }

    @NotNull
    private static Set<String> getTrackedRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitRefManager", "getTrackedRemoteBranches"));
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashSet<String> tracked = new HashSet<String>();
        for (GitBranchTrackInfo info : repository.getBranchTrackInfos()) {
            GitRemoteBranch trackedRemoteBranch = info.getRemoteBranch();
            if (!all.contains(trackedRemoteBranch)) continue;
            tracked.add(trackedRemoteBranch.getName());
        }
        HashSet<String> hashSet = tracked;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getTrackedRemoteBranches"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, GitRemote> getAllRemoteBranches(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/log/GitRefManager", "getAllRemoteBranches"));
        }
        HashSet<GitRemoteBranch> all = new HashSet<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        HashMap allRemote = ContainerUtil.newHashMap();
        for (GitRemoteBranch remoteBranch : all) {
            allRemote.put(remoteBranch.getName(), remoteBranch.getRemote());
        }
        HashMap hashMap = allRemote;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getAllRemoteBranches"));
        }
        return hashMap;
    }

    private static Set<String> getTrackedRemoteBranchesFromConfig(GitRepository repository) {
        return ContainerUtil.map2Set(repository.getBranchTrackInfos(), (Function)new Function<GitBranchTrackInfo, String>(){

            public String fun(GitBranchTrackInfo trackInfo) {
                return trackInfo.getRemoteBranch().getName();
            }
        });
    }

    @NotNull
    private static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Iterable<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/log/GitRefManager", "groupRefsByRoot"));
        }
        MultiMap grouped = MultiMap.create();
        for (VcsRef ref : refs) {
            grouped.putValue((Object)ref.getRoot(), (Object)ref);
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "groupRefsByRoot"));
        }
        return multiMap;
    }

    @NotNull
    public static VcsRefType getRefType(@NotNull String refName) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "git4idea/log/GitRefManager", "getRefType"));
        }
        if (refName.startsWith("refs/heads/")) {
            VcsRefType vcsRefType = LOCAL_BRANCH;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        if (refName.startsWith("refs/remotes/")) {
            VcsRefType vcsRefType = REMOTE_BRANCH;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        if (refName.startsWith("refs/tags/")) {
            VcsRefType vcsRefType = TAG;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        if (refName.startsWith("HEAD")) {
            VcsRefType vcsRefType = HEAD;
            if (vcsRefType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
            }
            return vcsRefType;
        }
        VcsRefType vcsRefType = OTHER;
        if (vcsRefType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager", "getRefType"));
        }
        return vcsRefType;
    }

    private static abstract class GitRefComparator
    implements Comparator<VcsRef> {
        @NotNull
        private final RepositoryManager<GitRepository> myRepositoryManager;

        GitRefComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            if (repositoryManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager$GitRefComparator", "<init>"));
            }
            this.myRepositoryManager = repositoryManager;
        }

        @Override
        public int compare(@NotNull VcsRef ref1, @NotNull VcsRef ref2) {
            int power2;
            if (ref1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref1", "git4idea/log/GitRefManager$GitRefComparator", "compare"));
            }
            if (ref2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref2", "git4idea/log/GitRefManager$GitRefComparator", "compare"));
            }
            int power1 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref1)));
            if (power1 != (power2 = ArrayUtil.find((Object[])this.getOrderedTypes(), (Object)((Object)this.getType(ref2))))) {
                return power1 - power2;
            }
            int namesComparison = ref1.getName().compareTo(ref2.getName());
            if (namesComparison != 0) {
                return namesComparison;
            }
            return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }

        protected abstract RefType[] getOrderedTypes();

        @NotNull
        private RefType getType(@NotNull VcsRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
            }
            VcsRefType type = ref.getType();
            if (type == HEAD) {
                RefType refType = RefType.HEAD;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            if (type == TAG) {
                RefType refType = RefType.TAG;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            if (type == LOCAL_BRANCH) {
                if (ref.getName().equals(GitRefManager.MASTER)) {
                    RefType refType = RefType.MASTER;
                    if (refType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                    }
                    return refType;
                }
                RefType refType = this.isTracked(ref, false) ? RefType.TRACKING_LOCAL_BRANCH : RefType.NON_TRACKING_LOCAL_BRANCH;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            if (type == REMOTE_BRANCH) {
                if (ref.getName().equals(GitRefManager.ORIGIN_MASTER)) {
                    RefType refType = RefType.ORIGIN_MASTER;
                    if (refType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                    }
                    return refType;
                }
                RefType refType = this.isTracked(ref, true) ? RefType.TRACKED_REMOTE_BRANCH : RefType.NON_TRACKED_REMOTE_BRANCH;
                if (refType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
                }
                return refType;
            }
            RefType refType = RefType.OTHER;
            if (refType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$GitRefComparator", "getType"));
            }
            return refType;
        }

        private boolean isTracked(final @NotNull VcsRef ref, final boolean remoteBranch) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "git4idea/log/GitRefManager$GitRefComparator", "isTracked"));
            }
            GitRepository repo = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(ref.getRoot());
            if (repo == null) {
                LOG.error("Undefined root " + ref.getRoot());
                return false;
            }
            return ContainerUtil.exists(repo.getBranchTrackInfos(), (Condition)new Condition<GitBranchTrackInfo>(){

                public boolean value(GitBranchTrackInfo info) {
                    return remoteBranch ? info.getRemoteBranch().getNameForLocalOperations().equals(ref.getName()) : info.getLocalBranch().getName().equals(ref.getName());
                }
            });
        }
    }

    private static class GitBranchLayoutComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.HEAD, RefType.OTHER};

        GitBranchLayoutComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            if (repositoryManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager$GitBranchLayoutComparator", "<init>"));
            }
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private static class GitLabelComparator
    extends GitRefComparator {
        private static final RefType[] ORDERED_TYPES = new RefType[]{RefType.HEAD, RefType.MASTER, RefType.TRACKING_LOCAL_BRANCH, RefType.NON_TRACKING_LOCAL_BRANCH, RefType.ORIGIN_MASTER, RefType.TRACKED_REMOTE_BRANCH, RefType.NON_TRACKED_REMOTE_BRANCH, RefType.TAG, RefType.OTHER};

        GitLabelComparator(@NotNull RepositoryManager<GitRepository> repositoryManager) {
            if (repositoryManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/log/GitRefManager$GitLabelComparator", "<init>"));
            }
            super(repositoryManager);
        }

        @Override
        protected RefType[] getOrderedTypes() {
            return ORDERED_TYPES;
        }
    }

    private class RemoteRefGroup
    implements RefGroup {
        private final GitRemote myRemote;
        private final Collection<VcsRef> myBranches;

        public RemoteRefGroup(GitRemote remote, Collection<VcsRef> branches) {
            this.myRemote = remote;
            this.myBranches = branches;
        }

        public boolean isExpanded() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.myRemote.getName() + "/...";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getName"));
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List list = ContainerUtil.sorted(this.myBranches, GitRefManager.this.getLabelsOrderComparator());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getRefs"));
            }
            return list;
        }

        @NotNull
        public Color getBgColor() {
            Color color = VcsLogStandardColors.Refs.BRANCH_REF;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$RemoteRefGroup", "getBgColor"));
            }
            return color;
        }
    }

    private static class LogicalRefGroup
    implements RefGroup {
        private final String myGroupName;
        private final List<VcsRef> myRefs;

        private LogicalRefGroup(String groupName, List<VcsRef> refs) {
            this.myGroupName = groupName;
            this.myRefs = refs;
        }

        public boolean isExpanded() {
            return true;
        }

        @NotNull
        public String getName() {
            String string = this.myGroupName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getName"));
            }
            return string;
        }

        @NotNull
        public List<VcsRef> getRefs() {
            List<VcsRef> list = this.myRefs;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getRefs"));
            }
            return list;
        }

        @NotNull
        public Color getBgColor() {
            Color color = VcsLogStandardColors.Refs.TIP;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$LogicalRefGroup", "getBgColor"));
            }
            return color;
        }
    }

    private static class SimpleRefType
    implements VcsRefType {
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;
        @NotNull
        private final String myName;

        public SimpleRefType(boolean isBranch, @NotNull Color color, @NotNull String typeName) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "git4idea/log/GitRefManager$SimpleRefType", "<init>"));
            }
            if (typeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "git4idea/log/GitRefManager$SimpleRefType", "<init>"));
            }
            this.myIsBranch = isBranch;
            this.myColor = color;
            this.myName = typeName;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitRefManager$SimpleRefType", "getBackgroundColor"));
            }
            return color;
        }

        public String toString() {
            return this.myName;
        }
    }

    protected static enum RefType {
        OTHER,
        HEAD,
        TAG,
        NON_TRACKING_LOCAL_BRANCH,
        NON_TRACKED_REMOTE_BRANCH,
        TRACKING_LOCAL_BRANCH,
        MASTER,
        TRACKED_REMOTE_BRANCH,
        ORIGIN_MASTER;

    }
}

