/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.css;

import com.intellij.gwt.clientBundle.css.language.psi.GwtCssDef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GwtCssDeclarationsManager {
    private static final Key<ParameterizedCachedValue<MultiMap<String, CssElement>, CssFile>> GWT_CSS_DECLARATIONS_KEY = Key.create((String)"GWT_CSS_DECLARATIONS");
    private static final GwtCssDeclarationsProvider DECLARATIONS_PROVIDER = new GwtCssDeclarationsProvider();

    private GwtCssDeclarationsManager() {
    }

    public static void collectCssClasses(CssRuleset cssRuleset, MultiMap<String, ? super CssClass> cssClass2Declaration) {
        for (CssSelector selector : cssRuleset.getSelectors()) {
            for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                CssSelectorSuffix[] selectorSuffixes;
                for (CssSelectorSuffix suffix : selectorSuffixes = simpleSelector.getSelectorSuffixes()) {
                    if (!(suffix instanceof CssClass)) continue;
                    CssClass cssClass = (CssClass)suffix;
                    cssClass2Declaration.putValue((Object)cssClass.getName(), (Object)cssClass);
                }
            }
        }
    }

    @NotNull
    public static Collection<CssElement> findDeclarations(@NotNull CssFile file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        Collection collection = GwtCssDeclarationsManager.getOrCreateDeclarationsMap(file).get((Object)name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        return collection;
    }

    @NotNull
    public static <T extends CssElement> Collection<T> findDeclarations(@NotNull CssFile file, @NotNull String name, @NotNull Class<T> aClass) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        List list = ContainerUtil.findAll((Collection)GwtCssDeclarationsManager.getOrCreateDeclarationsMap(file).get((Object)name), aClass);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "findDeclarations"));
        }
        return list;
    }

    public static <T extends CssElement> void collectDeclarations(@NotNull CssFile file, @NotNull Class<T> aClass, @NotNull MultiMap<String, T> result) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "collectDeclarations"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "collectDeclarations"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "collectDeclarations"));
        }
        MultiMap<String, CssElement> declarations = GwtCssDeclarationsManager.getOrCreateDeclarationsMap(file);
        for (String name : declarations.keySet()) {
            for (CssElement element : declarations.get((Object)name)) {
                if (!aClass.isInstance(element)) continue;
                result.putValue((Object)name, aClass.cast(element));
            }
        }
    }

    private static MultiMap<String, CssElement> getOrCreateDeclarationsMap(@NotNull CssFile cssFile) {
        if (cssFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssFile", "com/intellij/gwt/clientBundle/css/GwtCssDeclarationsManager", "getOrCreateDeclarationsMap"));
        }
        return (MultiMap)CachedValuesManager.getManager((Project)cssFile.getProject()).getParameterizedCachedValue((UserDataHolder)cssFile, GWT_CSS_DECLARATIONS_KEY, (ParameterizedCachedValueProvider)DECLARATIONS_PROVIDER, false, (Object)cssFile);
    }

    private static class GwtCssDeclarationsProvider
    implements ParameterizedCachedValueProvider<MultiMap<String, CssElement>, CssFile> {
        private GwtCssDeclarationsProvider() {
        }

        public CachedValueProvider.Result<MultiMap<String, CssElement>> compute(CssFile param) {
            final MultiMap result = new MultiMap();
            param.accept((PsiElementVisitor)new CssElementVisitor(){

                public void visitCssRuleset(CssRuleset ruleset) {
                    GwtCssDeclarationsManager.collectCssClasses(ruleset, (MultiMap<String, ? super CssClass>)result);
                }

                public void visitElement(PsiElement element) {
                    if (element instanceof GwtCssDef) {
                        GwtCssDef cssDef = (GwtCssDef)element;
                        result.putValue((Object)cssDef.getName(), (Object)cssDef);
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{param});
        }
    }
}

