/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.jam;

import com.intellij.gwt.clientBundle.ClientBundleUtil;
import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.clientBundle.css.language.psi.GwtCssDef;
import com.intellij.gwt.clientBundle.jam.CssClassNameConverter;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssResourceMethodJamElement
implements JamElement {
    private static final JamStringAttributeMeta.Single<String> CLASS_NAME_META = JamAttributeMeta.singleString((String)"value", (JamConverter)new CssClassNameConverter());
    private static final JamAnnotationMeta CSS_CLASS_META = new JamAnnotationMeta("com.google.gwt.resources.client.CssResource.ClassName").addAttribute(CLASS_NAME_META);
    public static final JamMethodMeta<CssResourceMethodJamElement> META = new JamMethodMeta(CssResourceMethodJamElement.class).addAnnotation(CSS_CLASS_META);

    @JamPsiConnector
    @NotNull
    public abstract PsiMethod getPsiMethod();

    @NotNull
    public List<CssElement> findCssElements() {
        PsiClass psiClass = this.getPsiMethod().getContainingClass();
        if (psiClass == null) {
            List<CssElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssResourceMethodJamElement", "findCssElements"));
            }
            return list;
        }
        Set<CssFile> files = ClientBundleUtil.getCssFiles(psiClass, true, true);
        if (files.isEmpty()) {
            List<CssElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssResourceMethodJamElement", "findCssElements"));
            }
            return list;
        }
        String cssClassName = this.getCssClassName();
        String defName = this.getPsiMethod().getName();
        ArrayList<CssElement> result = new ArrayList<CssElement>();
        for (CssFile file : files) {
            result.addAll(GwtCssDeclarationsManager.findDeclarations(file, cssClassName, CssClass.class));
            result.addAll(GwtCssDeclarationsManager.findDeclarations(file, defName, GwtCssDef.class));
        }
        ArrayList<CssElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssResourceMethodJamElement", "findCssElements"));
        }
        return arrayList;
    }

    public String getCssClassName() {
        String value = (String)this.getClassNameAttributeElement().getValue();
        if (value != null) {
            return value;
        }
        return this.getPsiMethod().getName();
    }

    @NotNull
    public JamStringAttributeElement<String> getClassNameAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)CSS_CLASS_META.getAttribute((PsiModifierListOwner)this.getPsiMethod(), CLASS_NAME_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/CssResourceMethodJamElement", "getClassNameAttributeElement"));
        }
        return jamStringAttributeElement;
    }

    @Nullable
    public static CssResourceMethodJamElement getJamElement(PsiMethod method) {
        return (CssResourceMethodJamElement)JamService.getJamService((Project)method.getProject()).getJamElement(META.getJamKey(), (PsiElement)method);
    }
}

