/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.FacetManager;
import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetArtifactValidator;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtLibrarySearchingPolicy;
import com.intellij.gwt.facet.GwtSdkPathEditor;
import com.intellij.gwt.make.GwtCompilerWorkspaceConfiguration;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.gwt.sdk.GwtSdkUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;

public class GwtFacetEditor
extends FacetEditorTab {
    @NonNls
    private static final String NONE = GwtBundle.message("gwt.package.web.facet.none", new Object[0]);
    private JComboBox myOutputStyleBox;
    private JPanel myMainPanel;
    private JComboBox myWebFacetBox;
    private JTextField myCompilerHeapSizeField;
    private JPanel myGwtSdkEditorPlace;
    private JPanel myPackagingPathsPanel;
    private JTextField myCompilerVMParametersField;
    private JTextField myCompilerParametersField;
    private JPanel myGwtSdkPathPanel;
    private JLabel myUsedSdkLabel;
    private JCheckBox myShowCompilerOutputCheckBox;
    private JPanel myPackagingTablePanel;
    private final FacetEditorContext myEditorContext;
    private final GwtSdkPathEditor myGwtPathEditor;
    private final FacetValidatorsManager myValidatorsManager;
    private final GwtFacetConfiguration myConfiguration;
    private final TableView<ModulePackagingInfo> myTableView;
    private List<ModulePackagingInfo> myOriginalModulePackagingInfos;
    private List<ModulePackagingInfo> myModulePackagingInfos;
    private final ListTableModel<ModulePackagingInfo> myTableModel;
    private static final ColumnInfo<ModulePackagingInfo, Boolean> ENABLED_COLUMN = new ColumnInfo<ModulePackagingInfo, Boolean>(""){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(ModulePackagingInfo modulePackagingInfo) {
            return modulePackagingInfo.myEnabled;
        }

        public boolean isCellEditable(ModulePackagingInfo modulePackagingInfo) {
            return !modulePackagingInfo.myLibraryModule;
        }

        public void setValue(ModulePackagingInfo modulePackagingInfo, Boolean value) {
            modulePackagingInfo.myEnabled = value;
        }
    };
    private static final ColumnInfo<ModulePackagingInfo, String> MODULE_NAME_COLUMN = new ColumnInfo<ModulePackagingInfo, String>(GwtBundle.message("table.column.name.gwt.module", new Object[0])){

        public String valueOf(ModulePackagingInfo modulePackagingInfo) {
            return modulePackagingInfo.myModuleName;
        }
    };
    private static final ColumnInfo<ModulePackagingInfo, String> OUTPUT_PATH_COLUMN = new ColumnInfo<ModulePackagingInfo, String>(GwtBundle.message("table.column.name.output.relative.path", new Object[0])){

        public String valueOf(ModulePackagingInfo modulePackagingInfo) {
            return modulePackagingInfo.myOutputPath;
        }

        public boolean isCellEditable(ModulePackagingInfo modulePackagingInfo) {
            return !modulePackagingInfo.myLibraryModule;
        }

        public void setValue(ModulePackagingInfo modulePackagingInfo, String value) {
            modulePackagingInfo.myOutputPath = value;
        }
    };

    public GwtFacetEditor(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager, GwtFacetConfiguration configuration) {
        this.myEditorContext = editorContext;
        this.myValidatorsManager = validatorsManager;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        Project project = editorContext.getProject();
        this.myGwtPathEditor = new GwtSdkPathEditor(project);
        this.myGwtSdkEditorPlace.add((Component)this.myGwtPathEditor.getMainComponent(), "Center");
        final Module module = editorContext.getModule();
        this.myWebFacetBox.addItem(NONE);
        for (WebFacet webFacet : editorContext.getFacetsProvider().getFacetsByType(module, WebFacet.ID)) {
            this.myWebFacetBox.addItem(webFacet.getName());
        }
        this.myWebFacetBox.setSelectedIndex(0);
        GwtFacetEditor.setupGwtOutputStyleCombobox(this.myOutputStyleBox);
        this.myWebFacetBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value);
                    WebFacet webFacet = (WebFacet)FacetManager.getInstance((Module)module).findFacet(WebFacet.ID, value);
                    if (webFacet != null) {
                        this.setIcon(webFacet.getType().getIcon());
                    }
                }
            }
        });
        validatorsManager.registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                String type = GwtFacetEditor.this.myConfiguration.getGwtSdkType();
                if (type != null) {
                    ValidationResult validationResult = ValidationResult.OK;
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetEditor$2", "check"));
                    }
                    return validationResult;
                }
                String path = GwtFacetEditor.this.myGwtPathEditor.getPath();
                ValidationResult result = GwtSdkUtil.checkGwtSdkPath(path);
                if (result.isOk()) {
                    result = GwtFacetEditor.this.checkUserJarLibrary(path);
                }
                ValidationResult validationResult = result;
                if (validationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetEditor$2", "check"));
                }
                return validationResult;
            }
        }, new JComponent[]{this.myGwtPathEditor.getComboBox()});
        validatorsManager.registerValidator((FacetEditorValidator)new GwtFacetArtifactValidator((GwtFacet)editorContext.getFacet(), this.myEditorContext, this), new JComponent[0]);
        ColumnInfo[] columns = new ColumnInfo[]{ENABLED_COLUMN, MODULE_NAME_COLUMN, OUTPUT_PATH_COLUMN};
        this.myModulePackagingInfos = new ArrayList<ModulePackagingInfo>();
        this.myOriginalModulePackagingInfos = new ArrayList<ModulePackagingInfo>();
        this.myTableModel = new ListTableModel(columns, this.myModulePackagingInfos, 0);
        this.myTableView = new TableView(this.myTableModel);
        TableColumnModel columnModel = this.myTableView.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSel, hasFocus, row, column);
                String tooltip = GwtFacetEditor.this.getTooltip(row);
                this.setToolTipText(tooltip);
                return component;
            }
        });
        TableUtil.setupCheckboxColumn((TableColumn)column);
        columnModel.getColumn(1).setCellRenderer(new TableCellRendererWithTooltip());
        columnModel.getColumn(2).setCellRenderer(new TableCellRendererWithTooltip());
        this.myPackagingTablePanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTableView), "Center");
    }

    @Nullable
    private String getTooltip(int row) {
        ModulePackagingInfo info;
        List items = this.myTableModel.getItems();
        if (0 <= row && row < items.size() && (info = (ModulePackagingInfo)items.get(row)).myLibraryModule) {
            return "GWT modules without entry points cannot be compiled";
        }
        return null;
    }

    public static void setupGwtOutputStyleCombobox(JComboBox comboBox) {
        for (GwtJavaScriptOutputStyle style : GwtJavaScriptOutputStyle.values()) {
            comboBox.addItem(style);
        }
        comboBox.setRenderer(new ListCellRendererWrapper<GwtJavaScriptOutputStyle>(){

            public void customize(JList list, GwtJavaScriptOutputStyle value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getPresentableName());
                }
            }
        });
    }

    public JComboBox getOutputStyleBox() {
        return this.myOutputStyleBox;
    }

    public JTextField getCompilerHeapSizeField() {
        return this.myCompilerHeapSizeField;
    }

    public GwtSdkPathEditor getGwtPathEditor() {
        return this.myGwtPathEditor;
    }

    public void onTabEntering() {
        this.myValidatorsManager.validate();
    }

    private ValidationResult checkUserJarLibrary(String sdkPath) {
        String userJarPath = GwtSdkPathUtil.getUserJarPath((String)sdkPath);
        final VirtualFile userJar = JarFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)userJarPath) + "!/");
        ModuleRootModel rootModel = this.myEditorContext.getRootModel();
        if (userJar == null) {
            return ValidationResult.OK;
        }
        GwtLibrarySearchingPolicy searchingPolicy = new GwtLibrarySearchingPolicy(this.myEditorContext, userJar);
        boolean found = searchingPolicy.containsLibrary(rootModel);
        if (found) {
            return ValidationResult.OK;
        }
        final LibraryOrderEntry gwtLibrary = searchingPolicy.getGwtLibrary();
        String errorMessage = gwtLibrary == null ? GwtBundle.message("error.message.gwt.user.jar.library.not.found.in.dependencies.of.module", new Object[0]) : GwtBundle.message("error.message.gwt.user.jar.in.library.0.does.not.correspond.to.selected.gwt.installation", gwtLibrary.getPresentableName());
        return new ValidationResult(errorMessage, new FacetConfigurationQuickFix(){

            public void run(JComponent place) {
                ModifiableRootModel modifiableRootModel = GwtFacetEditor.this.myEditorContext.getModifiableRootModel();
                if (gwtLibrary != null && gwtLibrary.isValid()) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)gwtLibrary);
                }
                LibrariesContainer container = ((FacetEditorContextBase)GwtFacetEditor.this.myEditorContext).getContainer();
                Library library = GwtSdkUtil.findOrCreateGwtUserLibrary(container, userJar);
                modifiableRootModel.addLibraryEntry(library);
            }
        });
    }

    private GwtJavaScriptOutputStyle getOutputStyle() {
        return (GwtJavaScriptOutputStyle)this.myOutputStyleBox.getSelectedItem();
    }

    private JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.getMainPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetEditor", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return !this.myConfiguration.getGwtSdkPath().equals(this.myGwtPathEditor.getPath()) || this.myConfiguration.getOutputStyle() != this.getOutputStyle() || !Comparing.equal((String)this.myConfiguration.getWebFacetName(), (String)this.getSelectedWebFacet()) || !this.myConfiguration.getAdditionalCompilerVMParameters().equals(this.myCompilerVMParametersField.getText()) || !this.myConfiguration.getCompilerParameters().equals(this.myCompilerParametersField.getText()) || !String.valueOf(this.myConfiguration.getCompilerMaxHeapSize()).equals(this.myCompilerHeapSizeField.getText()) || this.getWorkspaceConfiguration().isShowCompilerOutput((GwtFacet)this.myEditorContext.getFacet()) != this.myShowCompilerOutputCheckBox.isSelected() || this.isPackagingSettingsModified();
    }

    private boolean isPackagingSettingsModified() {
        return !Comparing.haveEqualElements(this.myOriginalModulePackagingInfos, this.myModulePackagingInfos) || this.myTableView.isEditing();
    }

    public void apply() {
        String gwtUrl = this.myGwtPathEditor.getUrl();
        this.myConfiguration.setGwtSdkUrlAndType(gwtUrl);
        GwtSdk gwtSdk = this.myConfiguration.getSdk();
        GwtSdkManager.getInstance().moveToTop(gwtSdk);
        this.myConfiguration.setOutputStyle(this.getOutputStyle());
        this.myConfiguration.setWebFacetName(this.getSelectedWebFacet());
        this.myConfiguration.setAdditionalCompilerVMParameters(this.myCompilerVMParametersField.getText().trim());
        this.myConfiguration.setCompilerParameters(this.myCompilerParametersField.getText().trim());
        try {
            this.myConfiguration.setCompilerMaxHeapSize(Integer.parseInt(this.myCompilerHeapSizeField.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (ModulePackagingInfo packagingInfo : this.myModulePackagingInfos) {
            String outputPath = packagingInfo.myOutputPath;
            if (packagingInfo.myDefaultOutputPath.equals(outputPath)) {
                outputPath = null;
            }
            this.myConfiguration.setPackagingRelativePath(packagingInfo.myModuleName, outputPath);
            this.myConfiguration.setModuleCompilationEnabled(packagingInfo.myModuleName, packagingInfo.myEnabled);
        }
        this.getWorkspaceConfiguration().setShowCompilerOutput((GwtFacet)this.myEditorContext.getFacet(), this.myShowCompilerOutputCheckBox.isSelected());
    }

    private GwtCompilerWorkspaceConfiguration getWorkspaceConfiguration() {
        return GwtCompilerWorkspaceConfiguration.getInstance(this.myEditorContext.getProject());
    }

    @Nullable
    public String getSelectedWebFacet() {
        String name = (String)this.myWebFacetBox.getSelectedItem();
        return NONE.equals(name) ? null : name;
    }

    public void reset() {
        GwtSdkType sdkType;
        GwtSdk gwtSdk;
        this.myGwtPathEditor.setPath(this.myConfiguration.getGwtSdkPath());
        this.myOutputStyleBox.setSelectedItem(this.myConfiguration.getOutputStyle());
        String webFacetName = this.myConfiguration.getWebFacetName();
        this.myWebFacetBox.setSelectedItem(webFacetName != null ? webFacetName : NONE);
        this.myCompilerVMParametersField.setText(this.myConfiguration.getAdditionalCompilerVMParameters());
        this.myCompilerParametersField.setText(this.myConfiguration.getCompilerParameters());
        this.myCompilerHeapSizeField.setText(String.valueOf(this.myConfiguration.getCompilerMaxHeapSize()));
        Project project = this.myEditorContext.getProject();
        boolean gwtModulesAvailable = !DumbService.getInstance((Project)project).isDumb();
        ((CardLayout)this.myPackagingPathsPanel.getLayout()).show(this.myPackagingPathsPanel, gwtModulesAvailable ? "table" : "notAvailable");
        this.myModulePackagingInfos.clear();
        if (gwtModulesAvailable) {
            this.myOriginalModulePackagingInfos = this.computePackagingInfos();
            this.myModulePackagingInfos.addAll(this.computePackagingInfos());
            int gwtModulesCount = this.myModulePackagingInfos.size();
            int height = (this.myTableView.getRowHeight() + this.myTableView.getRowMargin()) * gwtModulesCount + this.myTableView.getTableHeader().getPreferredSize().height + 2;
            height = Math.max(height, this.myPackagingTablePanel.getMinimumSize().height);
            height = Math.min(height, 300);
            this.myPackagingTablePanel.setPreferredSize(new Dimension(this.myPackagingTablePanel.getPreferredSize().width, height));
            this.myTableModel.setItems(this.myModulePackagingInfos);
            this.myTableView.revalidate();
            this.myTableView.repaint();
        }
        if (this.myEditorContext.isNewFacet() && this.myConfiguration.getGwtSdkPath().length() == 0 && (gwtSdk = GwtSdkManager.getInstance().suggestGwtSdk()) != null) {
            this.myGwtPathEditor.setPath(VfsUtilCore.urlToPath((String)gwtSdk.getHomeDirectoryUrl()));
        }
        this.myUsedSdkLabel.setVisible((sdkType = GwtSdkType.findType(this.myConfiguration.getGwtSdkType())) != null && !sdkType.isEditable());
        if (sdkType != null) {
            this.myUsedSdkLabel.setText(sdkType.getPresentableName(this.myGwtPathEditor.getPath()) + " is used");
        }
        this.myGwtSdkPathPanel.setVisible(sdkType == null || sdkType.isEditable());
        this.myShowCompilerOutputCheckBox.setSelected(this.getWorkspaceConfiguration().isShowCompilerOutput((GwtFacet)this.myEditorContext.getFacet()));
    }

    private List<ModulePackagingInfo> computePackagingInfos() {
        ArrayList<ModulePackagingInfo> list = new ArrayList<ModulePackagingInfo>();
        GwtModulesManager modulesManager = GwtModulesManager.getInstance(this.myEditorContext.getProject());
        for (GwtModule gwtModule : modulesManager.getGwtModules(this.myEditorContext.getModule(), true)) {
            list.add(new ModulePackagingInfo(gwtModule, this.myConfiguration, modulesManager.isLibraryModule(gwtModule)));
        }
        return list;
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return GwtBundle.message("google.web.toolkit.title", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.modules.gwt.facet";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel3;
        JPanel jPanel4;
        JTextField jTextField3;
        JComboBox jComboBox2;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createLineBorder(Color.black), (String)ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("border.title.gwt.compilation"), (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.select.script.output.style.text"));
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputStyleBox = jComboBox2 = new JComboBox();
        jPanel7.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.gwt.compiler.heap.size"));
        jPanel7.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompilerHeapSizeField = jTextField3 = new JTextField();
        jPanel7.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(25, -1), null));
        this.myPackagingPathsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel7.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 7, new Dimension(-1, 50), null, null));
        this.myPackagingTablePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "table");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, "notAvailable");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("GWT Modules are not available while index update is in progress");
        jPanel8.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.additional.compiler.parameters"));
        jPanel7.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompilerVMParametersField = jTextField2 = new JTextField();
        jPanel7.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.gwt.compiler.parameters"));
        jPanel7.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompilerParametersField = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myShowCompilerOutputCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show compiler output");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myGwtSdkPathPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGwtSdkEditorPlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.path.to.gwt.installation"));
        jPanel2.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.select.web.facet.text"));
        jPanel9.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWebFacetBox = jComboBox = new JComboBox();
        jPanel9.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myUsedSdkLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField);
        jLabel7.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class TableCellRendererWithTooltip
    extends DefaultTableCellRenderer {
        private TableCellRendererWithTooltip() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(GwtFacetEditor.this.getTooltip(row));
            return component;
        }
    }

    private static class ModulePackagingInfo {
        private final String myModuleName;
        private String myOutputPath;
        private final String myDefaultOutputPath;
        private boolean myEnabled;
        private final boolean myLibraryModule;

        private ModulePackagingInfo(GwtModule gwtModule, GwtFacetConfiguration configuration, boolean libraryModule) {
            this.myModuleName = gwtModule.getQualifiedName();
            this.myOutputPath = configuration.getPackagingRelativePath(gwtModule);
            this.myDefaultOutputPath = GwtFacetConfiguration.getDefaultPackagingPath(gwtModule);
            this.myEnabled = configuration.isModuleCompilationEnabled(gwtModule) && !libraryModule;
            this.myLibraryModule = libraryModule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModulePackagingInfo that = (ModulePackagingInfo)o;
            return this.myModuleName.equals(that.myModuleName) && this.myOutputPath.equals(that.myOutputPath) && this.myEnabled == that.myEnabled;
        }

        public int hashCode() {
            return 239 * this.myModuleName.hashCode() + 31 * this.myOutputPath.hashCode() + (this.myEnabled ? 1 : 0);
        }
    }
}

