/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.gradle;

import com.intellij.gwt.gradle.GwtGradleSdk;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GwtGradleSdkType
extends GwtSdkType {
    public GwtGradleSdkType() {
        super("gradle");
    }

    @Override
    @NotNull
    public GwtSdk createSdk(String homeDirectoryUrl) {
        String homePath = VfsUtilCore.urlToPath((String)homeDirectoryUrl);
        GwtGradleSdk gwtGradleSdk = new GwtGradleSdk(homePath, GwtGradleSdkType.getVersion(homePath));
        if (gwtGradleSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/gradle/GwtGradleSdkType", "createSdk"));
        }
        return gwtGradleSdk;
    }

    @Override
    public boolean isValidSdkHomeDirectory(File directory) {
        File gwtDev = directory.getParentFile();
        if (gwtDev == null || !gwtDev.getName().equals("gwt-dev")) {
            return false;
        }
        File base = gwtDev.getParentFile();
        return base != null && base.getName().equals("com.google.gwt");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    private static String getVersion(String homePath) {
        return PathUtil.getFileName((String)homePath);
    }

    @Override
    public String getPresentableName(String sdkPath) {
        return "GWT " + GwtGradleSdkType.getVersion(sdkPath) + " SDK from Gradle Repository";
    }
}

