/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.module;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import org.jetbrains.annotations.NotNull;

public class GwtAllowedApiFilter
extends AllowedApiFilterExtension {
    public boolean isClassForbidden(@NotNull String fqn, @NotNull PsiElement place) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/gwt/module/GwtAllowedApiFilter", "isClassForbidden"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/gwt/module/GwtAllowedApiFilter", "isClassForbidden"));
        }
        PsiFile containingFile = place.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        GwtFacet facet = GwtFacet.findFacetByPsiElement(place);
        if (facet == null) {
            return false;
        }
        GwtModulesManager modulesManager = GwtModulesManager.getInstance(facet.getModule().getProject());
        if (modulesManager.findGwtModulesByClientSourceFile(virtualFile).isEmpty()) {
            return false;
        }
        GwtSdk sdk = ((GwtFacetConfiguration)facet.getConfiguration()).getSdk();
        return sdk.isValid() && !sdk.containsJreEmulationClass(fqn);
    }
}

