/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.gwt.run.GwtClasspathUtil;
import com.intellij.gwt.run.GwtCommandLineStateBase;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathsList;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.build.common.OutputLineReader;

public class GwtSuperDevModeState
extends GwtCommandLineStateBase {
    static final Key<Integer> PORT_KEY = Key.create((String)"gwtCodeServerPort");
    public static final int DEFAULT_PORT_NUMBER = 9876;
    private static final String WORK_DIR_PARAM = "-workDir";
    private final WebBrowser myBrowser;
    private final GwtRunConfiguration.GwtRunConfigurationState myState;
    @Nullable
    private File myWorkDir;
    private int myPort;

    public GwtSuperDevModeState(GwtFacet facet, ExecutionEnvironment environment, GwtRunConfiguration.GwtRunConfigurationState state, @NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/gwt/run/GwtSuperDevModeState", "<init>"));
        }
        super(environment, executor, facet, state);
        this.myPort = -1;
        this.myState = state;
        this.myBrowser = WebBrowserManager.getInstance().findBrowserById(state.BROWSER);
        String[] params = ParametersList.parse((String)this.myShellParameters);
        if (!ArrayUtil.contains((String)WORK_DIR_PARAM, (String[])params)) {
            this.myWorkDir = new File(this.getTempOutputDir(), "work");
        }
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters parameters = new JavaParameters();
        ParametersList programParameters = parameters.getProgramParametersList();
        PathsList sources = GwtClasspathUtil.getSourceRootsOfGwtModules(this.myModule, true);
        PathsList classPath = parameters.getClassPath();
        for (String path : sources.getPathList()) {
            if (new File(path).isDirectory()) {
                programParameters.add("-src");
                programParameters.add(path);
                continue;
            }
            classPath.add(path);
        }
        JavaParametersUtil.configureModule((Module)this.myModule, (JavaParameters)parameters, (int)7, (String)this.myState.ALTERNATIVE_JRE_PATH);
        parameters.getVMParametersList().addParametersString(this.myVMParameters);
        programParameters.addParametersString(this.myShellParameters);
        if (this.myWorkDir != null) {
            programParameters.add(WORK_DIR_PARAM);
            programParameters.add(this.myWorkDir.getAbsolutePath());
            parameters.setWorkingDirectory(this.myWorkDir);
        }
        parameters.setupEnvs(this.myState.ENVIRONMENT_VARIABLES, this.myState.PASS_PARENT_ENVS);
        this.addGwtModules(programParameters);
        parameters.setMainClass("com.google.gwt.dev.codeserver.CodeServer");
        GwtSdk sdk = ((GwtFacetConfiguration)this.myFacet.getConfiguration()).getSdk();
        classPath.addFirst(sdk.getDevJarPath());
        if (!GwtSuperDevModeState.containsUserJar(classPath)) {
            classPath.add(sdk.getUserJarPath());
        }
        classPath.add(sdk.getCodeServerJarPath());
        for (String jar : sdk.getAdditionalCompilerJars()) {
            classPath.add(jar);
        }
        return parameters;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/gwt/run/GwtSuperDevModeState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/gwt/run/GwtSuperDevModeState", "execute"));
        }
        if (this.myWorkDir != null) {
            this.myWorkDir.mkdirs();
        }
        ExecutionResult result = super.execute(executor, runner);
        if (this.myState.OPEN_IN_BROWSER) {
            result.getProcessHandler().addProcessListener((ProcessListener)new GwtSuperDevModeProcessListener(this.myBrowser));
        }
        PORT_KEY.set((UserDataHolder)result.getProcessHandler(), (Object)this.myPort);
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtSuperDevModeState", "execute"));
        }
        return executionResult;
    }

    private File getTempOutputDir() {
        return new File(GwtCompilerPaths.getOutputRoot(this.myModule), "superDevMode");
    }

    private static class GwtSuperDevModeProcessListener
    extends OutputLineReader
    implements ProcessListener {
        private static final String OPEN_URL_PREFIX = "Next, visit: ";
        private final WebBrowser myBrowser;

        public GwtSuperDevModeProcessListener(WebBrowser browser) {
            this.myBrowser = browser;
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                this.parseOutput(event.getText());
            }
        }

        public void processTerminated(ProcessEvent event) {
        }

        protected void parseLine(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/gwt/run/GwtSuperDevModeState$GwtSuperDevModeProcessListener", "parseLine"));
            }
            if (line.startsWith(OPEN_URL_PREFIX)) {
                BrowserLauncher.getInstance().browse(StringUtil.trimStart((String)line, (String)OPEN_URL_PREFIX), this.myBrowser);
            }
        }

        public void startNotified(ProcessEvent event) {
        }

        public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
        }
    }
}

