/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;

public abstract class GwtSdkBase
implements GwtSdk {
    private final Map<String, Boolean> myCachedJreEmulationClasses = new HashMap<String, Boolean>();
    @Nullable
    protected GwtVersion myVersion;
    protected final GwtSdkPaths myPaths;

    protected GwtSdkBase(GwtSdkPaths paths) {
        this.myPaths = paths;
    }

    @Override
    public boolean containsJreEmulationClass(String className) {
        Boolean contains = this.myCachedJreEmulationClasses.get(className);
        if (contains == null) {
            VirtualFile userJar = this.getUserJar();
            contains = userJar != null && userJar.findFileByRelativePath(GwtSdkUtil.getJreEmulationClassPath(className)) != null;
            this.myCachedJreEmulationClasses.put(className, contains);
        }
        return contains;
    }

    @Override
    @Nullable
    public PsiClass findJreEmulationClass(@NotNull PsiClass originalClass) {
        if (originalClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalClass", "com/intellij/gwt/sdk/impl/GwtSdkBase", "findJreEmulationClass"));
        }
        String className = originalClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        VirtualFile userJar = this.getUserJar();
        if (userJar == null) {
            return null;
        }
        VirtualFile root = userJar.findFileByRelativePath("com/google/gwt/emul/");
        if (root == null) {
            return null;
        }
        return (PsiClass)ContainerUtil.getFirstItem(GwtSuperSourceClassCache.getInstance(originalClass.getProject()).findClassesByQualifiedName(className, root));
    }

    @Override
    @NotNull
    public GwtVersion getVersion() {
        if (this.myVersion == null) {
            this.myVersion = this.detectVersion();
        }
        GwtVersion gwtVersion = this.myVersion;
        if (gwtVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtSdkBase", "getVersion"));
        }
        return gwtVersion;
    }

    @NotNull
    protected abstract GwtVersion detectVersion();

    @Override
    @Nullable
    public VirtualFile getUserJar() {
        return GwtSdkUtil.findJarFile(this.getUserJarPath());
    }

    @Override
    public String getHomeDirectoryUrl() {
        return this.myPaths.getHomeDirectoryUrl();
    }

    @Override
    public String getDevJarPath() {
        return this.myPaths.getDevJarPath(this.getVersion().isUseSystemIndependentGwtDevJar());
    }

    @Override
    public String getServletJarPath() {
        return this.myPaths.getServletJarPath();
    }

    @Override
    public String getUserJarPath() {
        return this.myPaths.getUserJarPath();
    }

    @Override
    public String getCodeServerJarPath() {
        return this.myPaths.getCodeServerJarPath();
    }

    @Override
    public List<String> getAdditionalCompilerJars() {
        return this.myPaths.getAdditionalCompilerJars();
    }
}

