/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.declarations;

import com.intellij.gwt.clientBundle.css.GwtCssDeclarationsManager;
import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclarationImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UiStyleElement
extends UiXmlVariableDeclarationImpl {
    @NonNls
    public static final String SRC_ATTRIBUTE = "src";
    @NonNls
    public static final String DEFAULT_FIELD_NAME = "style";

    public UiStyleElement(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiStyleElement", "<init>"));
        }
        super(tag, DEFAULT_FIELD_NAME);
    }

    public MultiMap<String, CssClass> collectCssDeclarations() {
        MultiMap declarations = new MultiMap();
        for (CssFile externalFile : this.getCssFiles()) {
            GwtCssDeclarationsManager.collectDeclarations(externalFile, CssClass.class, declarations);
        }
        return declarations;
    }

    @NotNull
    private List<CssFile> findExternalFiles() {
        ResolveResult[] resolveResults;
        FileReference cssFileReference;
        Object[] srcXmlAttributeValueReferences;
        FileReference anyFileReference;
        XmlAttributeValue srcXmlAttributeValueElement;
        XmlAttribute srcXmlAttribute = this.myTag.getAttribute(SRC_ATTRIBUTE);
        if (srcXmlAttribute != null && (srcXmlAttributeValueElement = srcXmlAttribute.getValueElement()) != null && (anyFileReference = (FileReference)ContainerUtil.findInstance((Object[])(srcXmlAttributeValueReferences = srcXmlAttributeValueElement.getReferences()), FileReference.class)) != null && (cssFileReference = anyFileReference.getFileReferenceSet().getLastReference()) != null && (resolveResults = cssFileReference.multiResolve(false)).length > 0) {
            List list = (List)Arrays.stream(resolveResults).map(ResolveResult::getElement).filter(CssFile.class::isInstance).map(CssFile.class::cast).collect(Collectors.toCollection(SmartList::new));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiStyleElement", "findExternalFiles"));
            }
            return list;
        }
        List<CssFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiStyleElement", "findExternalFiles"));
        }
        return list;
    }

    @NotNull
    public List<CssFile> getCssFiles() {
        SmartList files = this.findExternalFiles();
        for (XmlText text : this.myTag.getValue().getTextElements()) {
            List pairs = InjectedLanguageManager.getInstance((Project)text.getProject()).getInjectedPsiFiles((PsiElement)text);
            if (pairs == null) continue;
            for (Pair pair : pairs) {
                if (!(pair.getFirst() instanceof CssFile)) continue;
                if (files.isEmpty()) {
                    files = new SmartList((Object)((CssFile)pair.getFirst()));
                    continue;
                }
                files.add((CssFile)((CssFile)pair.getFirst()));
            }
        }
        SmartList smartList = files;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiStyleElement", "getCssFiles"));
        }
        return smartList;
    }
}

