/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class PathUtilEx {
    @NonNls
    private static final String IDEA_PREPEND_RTJAR = "idea.prepend.rtjar";
    private static final Function<Module, Sdk> MODULE_JDK = module -> ModuleRootManager.getInstance((Module)module).getSdk();
    private static final Convertor<Sdk, String> SDK_VERSION = new Convertor<Sdk, String>(){

        public String convert(Sdk sdk) {
            return sdk.getVersionString();
        }
    };

    private PathUtilEx() {
    }

    public static void addRtJar(PathsList pathsList) {
        String ideaRtJarPath = PathUtilEx.getIdeaRtJarPath();
        if (Boolean.getBoolean(IDEA_PREPEND_RTJAR)) {
            pathsList.addFirst(ideaRtJarPath);
        } else {
            pathsList.addTail(ideaRtJarPath);
        }
    }

    public static String getIdeaRtJarPath() {
        Class<JavacRunner> aClass = JavacRunner.class;
        return PathUtil.getJarPathForClass(aClass);
    }

    public static Sdk getAnyJdk(Project project) {
        return PathUtilEx.chooseJdk(project, Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
    }

    public static Sdk chooseJdk(Project project, Collection<Module> modules) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null) {
            return projectSdk;
        }
        return PathUtilEx.chooseJdk(modules);
    }

    public static Sdk chooseJdk(Collection<Module> modules) {
        List sdks = ContainerUtil.skipNulls((Collection)ContainerUtil.map((Collection)ContainerUtil.skipNulls(modules), MODULE_JDK));
        if (sdks.isEmpty()) {
            return null;
        }
        Collections.sort(sdks, ComparatorUtil.compareBy(SDK_VERSION, (Comparator)String.CASE_INSENSITIVE_ORDER));
        return (Sdk)sdks.get(sdks.size() - 1);
    }
}

