/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control.finalVar;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.control.finalVar.InvalidWriteAccessSearcher;
import org.jetbrains.plugins.groovy.codeInspection.control.finalVar.VariableInitializationChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrFieldControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrFinalVariableAccessInspection
extends BaseInspection {
    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitMethod(GrMethod method) {
                super.visitMethod(method);
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    this.processLocalVars(block);
                }
                if (method.isConstructor()) {
                    this.processFieldsInConstructors(method);
                }
            }

            @Override
            public void visitFile(GroovyFileBase file) {
                super.visitFile(file);
                if (file instanceof GroovyFile && file.isScript()) {
                    this.processLocalVars(file);
                }
            }

            @Override
            public void visitField(GrField field) {
                super.visitField(field);
                GrExpression initializer = field.getInitializerGroovy();
                if (initializer != null) {
                    this.processLocalVars(initializer);
                }
                if (field.hasModifierProperty("final") && !GrFinalVariableAccessInspection.isFieldInitialized(field)) {
                    this.registerError(field.getNameIdentifierGroovy(), GroovyBundle.message("variable.0.might.not.have.been.initialized", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @Override
            public void visitReferenceExpression(GrReferenceExpression ref) {
                super.visitReferenceExpression(ref);
                PsiElement resolved = ref.resolve();
                if (resolved instanceof GrField && ((GrField)resolved).hasModifierProperty("final")) {
                    GrField field = (GrField)resolved;
                    PsiClass containingClass = field.getContainingClass();
                    if (PsiUtil.isLValue(ref)) {
                        if (containingClass == null || !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true)) {
                            this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                        }
                    } else if (PsiUtil.isUsedInIncOrDec(ref) && (containingClass == null || !GrFinalVariableAccessInspection.isInsideConstructorOrInitializer(containingClass, ref, field.hasModifierProperty("static")))) {
                        this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                } else if (resolved instanceof GrParameter && ((GrParameter)resolved).getDeclarationScope() instanceof GrMethod && ((GrParameter)resolved).hasModifierProperty("final") && PsiUtil.isUsedInIncOrDec(ref)) {
                    this.registerError((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.parameter.0", ((GrParameter)resolved).getName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @Override
            public void visitClassInitializer(GrClassInitializer initializer) {
                super.visitClassInitializer(initializer);
                this.processLocalVars(initializer.getBlock());
                this.processFieldsInClassInitializer(initializer);
            }

            private void processFieldsInConstructors(@NotNull GrMethod constructor) {
                if (constructor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1", "processFieldsInConstructors"));
                }
                GrOpenBlock block = constructor.getBlock();
                if (block == null) {
                    return;
                }
                GrTypeDefinition clazz = (GrTypeDefinition)constructor.getContainingClass();
                if (clazz == null) {
                    return;
                }
                GrClassInitializer[] initializers = clazz.getInitializers();
                List fields = GrFinalVariableAccessInspection.getFinalFields(clazz);
                HashSet initializedFields = ContainerUtil.newHashSet();
                GrFinalVariableAccessInspection.appendFieldInitializedInDeclaration(false, fields, initializedFields);
                GrFinalVariableAccessInspection.appendFieldsInitializedInClassInitializer(initializers, null, false, fields, initializedFields);
                GrFinalVariableAccessInspection.appendInitializationFromChainedConstructors(constructor, fields, initializedFields);
                Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(block);
                Map variables = GrFinalVariableAccessInspection.buildVarMap(fields, false);
                this.highlightInvalidWriteAccess(flow, variables, initializedFields);
            }

            private void processFieldsInClassInitializer(@NotNull GrClassInitializer initializer) {
                if (initializer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1", "processFieldsInClassInitializer"));
                }
                GrTypeDefinition clazz = (GrTypeDefinition)initializer.getContainingClass();
                if (clazz == null) {
                    return;
                }
                boolean isStatic = initializer.isStatic();
                GrClassInitializer[] initializers = clazz.getInitializers();
                List fields = GrFinalVariableAccessInspection.getFinalFields(clazz);
                HashSet initializedFields = ContainerUtil.newHashSet();
                GrFinalVariableAccessInspection.appendFieldInitializedInDeclaration(isStatic, fields, initializedFields);
                GrFinalVariableAccessInspection.appendFieldsInitializedInClassInitializer(initializers, initializer, isStatic, fields, initializedFields);
                Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(initializer.getBlock());
                Map variables = GrFinalVariableAccessInspection.buildVarMap(fields, isStatic);
                this.highlightInvalidWriteAccess(flow, variables, initializedFields);
            }

            private void processLocalVars(@NotNull GroovyPsiElement scope) {
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1", "processLocalVars"));
                }
                MultiMap scopes = GrFinalVariableAccessInspection.collectVariables(scope);
                for (Map.Entry entry : scopes.entrySet()) {
                    PsiElement scopeToProcess = (PsiElement)entry.getKey();
                    HashSet forInParameters = ContainerUtil.newHashSet();
                    HashMap variables = ContainerUtil.newHashMap();
                    for (GrVariable var : (Collection)entry.getValue()) {
                        variables.put(var.getName(), var);
                        if (!(var instanceof GrParameter) || !(((GrParameter)var).getDeclarationScope() instanceof GrForStatement)) continue;
                        forInParameters.add(var);
                    }
                    Instruction[] flow = GrFinalVariableAccessInspection.getFlow(scopeToProcess);
                    this.highlightInvalidWriteAccess(flow, variables, forInParameters);
                }
            }

            private void highlightInvalidWriteAccess(@NotNull Instruction[] flow, @NotNull Map<String, GrVariable> variables, @NotNull Set<GrVariable> initializedVariables) {
                if (flow == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1", "highlightInvalidWriteAccess"));
                }
                if (variables == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1", "highlightInvalidWriteAccess"));
                }
                if (initializedVariables == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializedVariables", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection$1", "highlightInvalidWriteAccess"));
                }
                List<ReadWriteVariableInstruction> result = InvalidWriteAccessSearcher.findInvalidWriteAccess(flow, variables, initializedVariables);
                if (result == null) {
                    return;
                }
                for (ReadWriteVariableInstruction instruction : result) {
                    if (!variables.containsKey(instruction.getVariableName())) continue;
                    this.registerError(instruction.getElement(), GroovyBundle.message("cannot.assign.a.value.to.final.field.0", instruction.getVariableName()), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    private static boolean isInsideConstructorOrInitializer(@NotNull PsiClass containingClass, @NotNull GrReferenceExpression place, boolean isStatic) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "isInsideConstructorOrInitializer"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "isInsideConstructorOrInitializer"));
        }
        GrControlFlowOwner container = ControlFlowUtils.findControlFlowOwner(place);
        PsiClass aClass = null;
        if (!isStatic && container instanceof GrMethod && ((GrMethod)((Object)container)).isConstructor()) {
            aClass = ((GrMethod)((Object)container)).getContainingClass();
        } else if (container instanceof GrClassInitializer && ((GrClassInitializer)((Object)container)).isStatic() == isStatic) {
            aClass = ((GrClassInitializer)((Object)container)).getContainingClass();
        }
        return aClass != null && containingClass.getManager().areElementsEquivalent(aClass, (PsiElement)containingClass);
    }

    @NotNull
    private static List<GrField> getFinalFields(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "getFinalFields"));
        }
        Object[] fields = clazz.getCodeFields();
        List list = ContainerUtil.filter((Object[])fields, field -> {
            GrModifierList list = field.getModifierList();
            return list != null && list.hasModifierProperty("final");
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "getFinalFields"));
        }
        return list;
    }

    private static void appendFieldInitializedInDeclaration(boolean isStatic, @NotNull List<GrField> fields, @NotNull Set<GrVariable> initializedFields) {
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendFieldInitializedInDeclaration"));
        }
        if (initializedFields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializedFields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendFieldInitializedInDeclaration"));
        }
        for (GrField field : fields) {
            if (field.hasModifierProperty("static") != isStatic || field.getInitializerGroovy() == null) continue;
            initializedFields.add(field);
        }
    }

    private static void appendFieldsInitializedInClassInitializer(@NotNull GrClassInitializer[] initializers, @Nullable GrClassInitializer initializerToStop, boolean isStatic, @NotNull List<GrField> fields, @NotNull Set<GrVariable> initializedFields) {
        if (initializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializers", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendFieldsInitializedInClassInitializer"));
        }
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendFieldsInitializedInClassInitializer"));
        }
        if (initializedFields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializedFields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendFieldsInitializedInClassInitializer"));
        }
        for (GrClassInitializer curInit : initializers) {
            if (curInit.isStatic() != isStatic) continue;
            if (curInit == initializerToStop) break;
            GrOpenBlock block = curInit.getBlock();
            Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(block);
            for (GrField field : fields) {
                if (field.hasModifierProperty("static") != isStatic || initializedFields.contains(field) || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block, flow)) continue;
                initializedFields.add(field);
            }
        }
    }

    private static void appendInitializationFromChainedConstructors(@NotNull GrMethod constructor, @NotNull List<GrField> fields, @NotNull Set<GrVariable> initializedFields) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendInitializationFromChainedConstructors"));
        }
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendInitializationFromChainedConstructors"));
        }
        if (initializedFields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializedFields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "appendInitializationFromChainedConstructors"));
        }
        List<GrMethod> chained = GrFinalVariableAccessInspection.getChainedConstructors(constructor);
        chained.remove(0);
        for (GrMethod method : chained) {
            GrOpenBlock block = method.getBlock();
            if (block == null) continue;
            Instruction[] flow = GrFinalVariableAccessInspection.buildFlowForField(block);
            for (GrField field : fields) {
                if (field.hasModifierProperty("static") || initializedFields.contains(field) || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block, flow)) continue;
                initializedFields.add(field);
            }
        }
    }

    @NotNull
    private static Map<String, GrVariable> buildVarMap(@NotNull List<GrField> fields, boolean isStatic) {
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "buildVarMap"));
        }
        HashMap result = ContainerUtil.newHashMap();
        for (GrField field : fields) {
            if (field.hasModifierProperty("static") != isStatic) continue;
            result.put(field.getName(), field);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "buildVarMap"));
        }
        return hashMap;
    }

    private static boolean isFieldInitialized(@NotNull GrField field) {
        GrClassInitializer[] initializers;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "isFieldInitialized"));
        }
        if (field instanceof GrEnumConstant) {
            return true;
        }
        if (field.getInitializerGroovy() != null) {
            return true;
        }
        if (GrFinalVariableAccessInspection.isImmutableField(field)) {
            return true;
        }
        boolean isStatic = field.hasModifierProperty("static");
        GrTypeDefinition aClass = (GrTypeDefinition)field.getContainingClass();
        if (aClass == null) {
            return true;
        }
        for (GrClassInitializer initializer : initializers = aClass.getInitializers()) {
            Instruction[] initializerFlow;
            GrOpenBlock block;
            if (initializer.isStatic() != isStatic || !VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block = initializer.getBlock(), initializerFlow = GrFinalVariableAccessInspection.buildFlowForField(block))) continue;
            return true;
        }
        if (isStatic) {
            return false;
        }
        GrMethod[] constructors = aClass.getCodeConstructors();
        if (constructors.length == 0) {
            return false;
        }
        HashSet initializedConstructors = ContainerUtil.newHashSet();
        HashSet notInitializedConstructors = ContainerUtil.newHashSet();
        block1: for (GrMethod constructor : constructors) {
            if (constructor.getBlock() == null) {
                return false;
            }
            List<GrMethod> chained = GrFinalVariableAccessInspection.getChainedConstructors(constructor);
            for (GrMethod method : chained) {
                if (initializedConstructors.contains(method)) continue block1;
                if (notInitializedConstructors.contains(method)) continue;
                GrOpenBlock block = method.getBlock();
                assert (block != null);
                boolean initialized = VariableInitializationChecker.isVariableDefinitelyInitializedCached(field, block, GrFinalVariableAccessInspection.buildFlowForField(block));
                if (initialized) {
                    initializedConstructors.add(method);
                    continue block1;
                }
                notInitializedConstructors.add(method);
            }
            return false;
        }
        return true;
    }

    private static boolean isImmutableField(@NotNull GrField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "isImmutableField"));
        }
        GrModifierList fieldModifierList = field.getModifierList();
        if (fieldModifierList != null && fieldModifierList.hasExplicitVisibilityModifiers()) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        return PsiImplUtil.hasImmutableAnnotation(modifierList);
    }

    @NotNull
    private static List<GrMethod> getChainedConstructors(@NotNull GrMethod constructor) {
        PsiMethod method;
        GrConstructorInvocation invocation;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "getChainedConstructors"));
        }
        HashSet visited = ContainerUtil.newHashSet();
        ArrayList result = ContainerUtil.newArrayList((Object[])new GrMethod[]{constructor});
        while ((invocation = PsiUtil.getConstructorInvocation(constructor)) != null && invocation.isThisCall() && (method = invocation.resolveMethod()) != null && method.isConstructor() && visited.add(method)) {
            result.add((GrMethod)method);
            constructor = (GrMethod)method;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "getChainedConstructors"));
        }
        return arrayList;
    }

    @NotNull
    private static Instruction[] buildFlowForField(@NotNull GrOpenBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "buildFlowForField"));
        }
        Instruction[] instructionArray = new ControlFlowBuilder(block.getProject(), GrFieldControlFlowPolicy.getInstance()).buildControlFlow(block);
        if (instructionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "buildFlowForField"));
        }
        return instructionArray;
    }

    @NotNull
    private static MultiMap<PsiElement, GrVariable> collectVariables(@NotNull GroovyPsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "collectVariables"));
        }
        final MultiMap scopes = MultiMap.create();
        scope.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariable(GrVariable variable) {
                PsiElement varScope;
                super.visitVariable(variable);
                if (!(variable instanceof PsiField) && variable.hasModifierProperty("final") && (varScope = GrFinalVariableAccessInspection.findScope(variable)) != null) {
                    scopes.putValue((Object)varScope, (Object)variable);
                }
            }
        });
        MultiMap multiMap = scopes;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "collectVariables"));
        }
        return multiMap;
    }

    @NotNull
    private static Instruction[] getFlow(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "getFlow"));
        }
        Instruction[] instructionArray = element instanceof GrControlFlowOwner ? ((GrControlFlowOwner)element).getControlFlow() : new ControlFlowBuilder(element.getProject()).buildControlFlow((GroovyPsiElement)element);
        if (instructionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "getFlow"));
        }
        return instructionArray;
    }

    @Nullable
    private static PsiElement findScope(@NotNull GrVariable variable) {
        GrStatement body;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/codeInspection/control/finalVar/GrFinalVariableAccessInspection", "findScope"));
        }
        GroovyPsiElement result = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{GrControlStatement.class, GrControlFlowOwner.class});
        if (result instanceof GrForStatement && (body = ((GrForStatement)result).getBody()) != null) {
            result = body;
        }
        return result;
    }
}

