/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityIcons;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionMembersCache;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrTypeDefinitionImpl
extends GrStubElementBase<GrTypeDefinitionStub>
implements GrTypeDefinition,
StubBasedPsiElement<GrTypeDefinitionStub> {
    private final GrTypeDefinitionMembersCache<GrTypeDefinition> myCache;

    public GrTypeDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "<init>"));
        }
        super(node);
        this.myCache = new GrTypeDefinitionMembersCache<GrTypeDefinitionImpl>(this);
    }

    protected GrTypeDefinitionImpl(GrTypeDefinitionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
        this.myCache = new GrTypeDefinitionMembersCache<GrTypeDefinitionImpl>(this);
    }

    @Override
    public PsiElement getParent() {
        return this.getDefinitionParent();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitTypeDefinition(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFile) {
            String packageName = ((GroovyFile)parent).getPackageName();
            return !packageName.isEmpty() ? packageName + "." + this.getName() : this.getName();
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && containingClass.getQualifiedName() != null) {
            return containingClass.getQualifiedName() + "." + this.getName();
        }
        return null;
    }

    @Override
    @Nullable
    public GrTypeDefinitionBody getBody() {
        return (GrTypeDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.CLASS_BODY);
    }

    @Override
    @NotNull
    public GrMembersDeclaration[] getMemberDeclarations() {
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            if (GrMembersDeclaration.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getMemberDeclarations"));
            }
            return GrMembersDeclaration.EMPTY_ARRAY;
        }
        GrMembersDeclaration[] grMembersDeclarationArray = body.getMemberDeclarations();
        if (grMembersDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getMemberDeclarations"));
        }
        return grMembersDeclarationArray;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @Nullable
    public GrExtendsClause getExtendsClause() {
        return (GrExtendsClause)this.getStubOrPsiChild(GroovyElementTypes.EXTENDS_CLAUSE);
    }

    @Override
    @Nullable
    public GrImplementsClause getImplementsClause() {
        return (GrImplementsClause)this.getStubOrPsiChild(GroovyElementTypes.IMPLEMENTS_CLAUSE);
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement result = this.findChildByType(TokenSets.PROPERTY_NAMES);
        assert (result != null);
        PsiElement psiElement = result;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        GroovyFileImpl file;
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFileImpl && (file = (GroovyFileImpl)parent).getTypeDefinitions().length == 1 && !file.isScript()) {
            file.delete();
            return;
        }
        super.delete();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "processDeclarations"));
        }
        return GrClassImplUtil.processDeclarations(this, processor, state, lastParent, place);
    }

    @Override
    public String getName() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PsiImplUtil.getName(this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return GrClassImplUtil.isClassEquivalentTo(this, another);
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isTrait() {
        return false;
    }

    @Nullable
    public PsiReferenceList getExtendsList() {
        return this.getExtendsClause();
    }

    @Nullable
    public PsiReferenceList getImplementsList() {
        return this.getImplementsClause();
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = this.myCache.getExtendsListTypes(includeSynthetic);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = this.myCache.getImplementsListTypes(includeSynthetic);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getImplementsListTypes"));
        }
        return psiClassTypeArray;
    }

    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this);
    }

    public PsiClass[] getInterfaces() {
        return GrClassImplUtil.getInterfaces(this);
    }

    @Override
    @NotNull
    public final PsiClass[] getSupers(boolean includeSynthetic) {
        PsiClass[] psiClassArray = GrClassImplUtil.getSupers(this, includeSynthetic);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getSupers"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = GrClassImplUtil.getSuperTypes(this, includeSynthetic);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getSuperTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public GrField[] getCodeFields() {
        GrField[] grFieldArray = this.myCache.getCodeFields();
        if (grFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getCodeFields"));
        }
        return grFieldArray;
    }

    @Override
    public PsiField findCodeFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, false);
    }

    @Override
    @NotNull
    public GrField[] getFields() {
        GrField[] grFieldArray = this.myCache.getFields();
        if (grFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getFields"));
        }
        return grFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public GrMethod[] getCodeMethods() {
        GrMethod[] grMethodArray = this.myCache.getCodeMethods();
        if (grMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getCodeMethods"));
        }
        return grMethodArray;
    }

    public void subtreeChanged() {
        this.myCache.dropCaches();
        super.subtreeChanged();
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public GrMethod[] getCodeConstructors() {
        GrMethod[] grMethodArray = this.myCache.getCodeConstructors();
        if (grMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getCodeConstructors"));
        }
        return grMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public GrTypeDefinition[] getCodeInnerClasses() {
        GrTypeDefinition[] grTypeDefinitionArray = this.myCache.getCodeInnerClasses();
        if (grTypeDefinitionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getCodeInnerClasses"));
        }
        return grTypeDefinitionArray;
    }

    @Override
    @NotNull
    public GrClassInitializer[] getInitializers() {
        GrTypeDefinitionBody body = this.getBody();
        GrClassInitializer[] grClassInitializerArray = body != null ? body.getInitializers() : GrClassInitializer.EMPTY_ARRAY;
        if (grClassInitializerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getInitializers"));
        }
        return grClassInitializerArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = GrClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = GrClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        return GrClassImplUtil.findFieldByName(this, name, checkBases, true);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return GrClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findCodeMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findCodeMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "findCodeMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(this, name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findCodeMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findCodeMethodsByName(this, name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "findCodeMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = GrClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = GrClassImplUtil.getAllMethodsAndTheirSubstitutors(this);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getAllMethodsAndTheirSubstitutors"));
        }
        return list;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return GrClassImplUtil.findInnerClassByName(this, name, checkBases);
    }

    @Nullable
    public PsiElement getLBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getLBrace();
    }

    @Nullable
    public PsiElement getRBrace() {
        GrTypeDefinitionBody body = this.getBody();
        return body == null ? null : body.getRBrace();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @Nullable
    public PsiElement getScope() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        ASTNode treeElement = this.getNode();
        for (ASTNode parent = treeElement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!(parent.getElementType() instanceof IStubElementType) || parent.getElementType() == GroovyElementTypes.CLASS_BODY) continue;
            return parent.getPsi();
        }
        return this.getContainingFile();
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "isInheritor"));
        }
        if (this.isTrait() && baseClass.isInterface() && !checkDeep) {
            for (PsiClassType superType : this.getImplementsListTypes()) {
                if (!this.getManager().areElementsEquivalent((PsiElement)superType.resolve(), (PsiElement)baseClass)) continue;
                return true;
            }
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection collection = PsiSuperMethodImplUtil.getVisibleSignatures((PsiClass)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getVisibleSignatures"));
        }
        return collection;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "setName"));
        }
        boolean renameFile = this.isRenameFileOnClassRenaming();
        String oldName = this.getName();
        PsiImplUtil.setName(name, this.getNameIdentifierGroovy());
        GrTypeDefinitionBody body = this.getBody();
        if (body != null) {
            for (GrMethod method : body.getMethods()) {
                if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
                method.setName(name);
            }
        }
        if (renameFile) {
            PsiFile file = this.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            String ext = virtualFile != null ? virtualFile.getExtension() : GroovyFileType.GROOVY_FILE_TYPE.getDefaultExtension();
            file.setName(name + "." + ext);
        }
        return this;
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS);
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "hasModifierProperty"));
        }
        GrModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.TYPE_PARAMETER_LIST);
    }

    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            GrTypeParameter[] grTypeParameterArray = list.getTypeParameters();
            if (grTypeParameterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getTypeParameters"));
            }
            return grTypeParameterArray;
        }
        if (GrTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "getTypeParameters"));
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getIconInner();
        boolean isLocked = (flags & 2) != 0 && !this.isWritable();
        RowIcon rowIcon = GrTypeDefinitionImpl.createLayeredIcon((Iconable)this, (Icon)icon, (int)(ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)isLocked) | this.getFlagsInner()));
        if ((flags & 1) != 0) {
            VisibilityIcons.setVisibilityIcon((PsiModifierList)this.getModifierList(), (RowIcon)rowIcon);
        }
        return rowIcon;
    }

    private int getFlagsInner() {
        return !DumbService.isDumb((Project)this.getProject()) && GroovyRunnerPsiUtil.isRunnable(this) ? 16384 : 0;
    }

    private Icon getIconInner() {
        if (this.isAnnotationType()) {
            return JetgroovyIcons.Groovy.AnnotationType;
        }
        if (this.isTrait()) {
            return JetgroovyIcons.Groovy.Trait;
        }
        if (this.isInterface()) {
            return JetgroovyIcons.Groovy.Interface;
        }
        if (this.isEnum()) {
            return JetgroovyIcons.Groovy.Enum;
        }
        if (this.hasModifierProperty("abstract")) {
            return JetgroovyIcons.Groovy.AbstractClass;
        }
        return JetgroovyIcons.Groovy.Class;
    }

    private boolean isRenameFileOnClassRenaming() {
        PsiFile file = this.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        if (groovyFile.isScript()) {
            return false;
        }
        String name = this.getName();
        VirtualFile vFile = groovyFile.getVirtualFile();
        return vFile != null && name != null && name.equals(vFile.getNameWithoutExtension());
    }

    @Nullable
    public PsiElement getOriginalElement() {
        return JavaPsiImplementationHelper.getInstance((Project)this.getProject()).getOriginalClass((PsiClass)this);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "addAfter"));
        }
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() == body) {
            PsiElement nextChild = anchor.getNextSibling();
            if (nextChild == null) {
                return this.add(element);
            }
            if (body == null) {
                throw new IncorrectOperationException("Class must have body");
            }
            return body.addBefore(element, nextChild);
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "addBefore"));
        }
        if (anchor == null) {
            return this.add(element);
        }
        GrTypeDefinitionBody body = this.getBody();
        if (anchor.getParent() != body) {
            return super.addBefore(element, anchor);
        }
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        return body.addBefore(element, anchor);
    }

    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiElement anchor;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionImpl", "add"));
        }
        GrTypeDefinitionBody body = this.getBody();
        if (body == null) {
            throw new IncorrectOperationException("Class must have body");
        }
        PsiElement lBrace = body.getLBrace();
        if (lBrace == null) {
            throw new IncorrectOperationException("No left brace");
        }
        PsiMember member = GrTypeDefinitionImpl.getAnyMember(psiElement);
        PsiElement psiElement2 = anchor = member != null ? this.getDefaultAnchor(body, member) : null;
        if (anchor == null) {
            anchor = lBrace.getNextSibling();
        }
        if (anchor != null) {
            ASTNode node = anchor.getNode();
            assert (node != null);
            if (GroovyTokenTypes.mSEMI.equals(node.getElementType())) {
                anchor = anchor.getNextSibling();
            }
            if (psiElement instanceof GrField) {
                int i = ArrayUtilRt.find((Object[])((GrVariableDeclaration)psiElement.getParent()).getVariables(), (Object)psiElement);
                psiElement = body.addBefore(psiElement.getParent(), anchor);
                GrVariable[] vars = ((GrVariableDeclaration)psiElement).getVariables();
                for (int j = 0; j < vars.length; ++j) {
                    if (i == j) continue;
                    vars[i].delete();
                }
                psiElement = vars[i];
            } else {
                psiElement = body.addBefore(psiElement, anchor);
            }
        } else {
            psiElement = body.add(psiElement);
        }
        return psiElement;
    }

    @Nullable
    private static PsiMember getAnyMember(@Nullable PsiElement psiElement) {
        GrMember[] members;
        if (psiElement instanceof PsiMember) {
            return (PsiMember)psiElement;
        }
        if (psiElement instanceof GrVariableDeclaration && (members = ((GrVariableDeclaration)psiElement).getMembers()).length > 0) {
            return members[0];
        }
        return null;
    }

    public static int getMemberOrderWeight(PsiElement member, GroovyCodeStyleSettingsFacade settings) {
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant) {
                return 1;
            }
            return ((PsiField)member).hasModifierProperty("static") ? settings.staticFieldsOrderWeight() + 1 : settings.fieldsOrderWeight() + 1;
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return settings.constructorsOrderWeight() + 1;
            }
            return ((PsiMethod)member).hasModifierProperty("static") ? settings.staticMethodsOrderWeight() + 1 : settings.methodsOrderWeight() + 1;
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).hasModifierProperty("static") ? settings.staticInnerClassesOrderWeight() + 1 : settings.innerClassesOrderWeight() + 1;
        }
        return -1;
    }

    @Nullable
    private PsiElement getDefaultAnchor(GrTypeDefinitionBody body, PsiMember member) {
        GroovyCodeStyleSettingsFacade settings = GroovyCodeStyleSettingsFacade.getInstance(this.getProject());
        int order = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)member, settings);
        if (order < 0) {
            return null;
        }
        PsiElement lastMember = null;
        for (PsiElement child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            int order1 = GrTypeDefinitionImpl.getMemberOrderWeight((PsiElement)GrTypeDefinitionImpl.getAnyMember(child), settings);
            if (order1 < 0) continue;
            if (order1 > order) {
                PsiElement lBrace = body.getLBrace();
                if (lastMember != null) {
                    PsiElement nextSibling = lastMember.getNextSibling();
                    while (nextSibling instanceof LeafPsiElement && (nextSibling.getText().equals(",") || nextSibling.getText().equals(";"))) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    return nextSibling == null && lBrace != null ? PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true) : nextSibling;
                }
                if (lBrace != null) {
                    return PsiUtil.skipWhitespacesAndComments(lBrace.getNextSibling(), true);
                }
            }
            lastMember = child;
        }
        return body.getRBrace();
    }
}

