/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlCallsInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlCallsInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                FtlMethodCallExpression call;
                FtlExpression expression;
                FtlCallableType type;
                if (element instanceof FtlMacro) {
                    FtlMacro macro = (FtlMacro)element;
                    FtlCallsInspection.checkCall(macro.getMacroType(), holder, macro.getArgumentList(), macro.getStartTagNameElement());
                } else if (element instanceof FtlMethodCallExpression && (type = FtlPsiUtil.asInstanceOf((expression = (call = (FtlMethodCallExpression)element).getMethodExpression()).getType(), FtlCallableType.class)) != null && !type.isMacro() && !(type instanceof FtlMethodType) && !(expression instanceof FtlBuiltIn) && type != FtlCallableType.TEMPLATE_METHOD_TYPE) {
                    FtlCallsInspection.checkCall(type, holder, call.getArgumentList(), expression);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlCallsInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static void checkCall(@Nullable FtlCallableType type, ProblemsHolder holder, FtlArgumentList argumentList, PsiElement callElement) {
        if (type == null) {
            return;
        }
        FtlExpression[] positionalArguments = argumentList.getPositionalArguments();
        List mandatoryParameters = ContainerUtil.findAll((Object[])type.getParameters(), ftlParameter -> ftlParameter.isMandatory());
        int posArgCount = positionalArguments.length;
        if (argumentList.isPositional() && posArgCount > 0) {
            if (posArgCount < mandatoryParameters.size()) {
                StringBuilder sb = new StringBuilder();
                for (int i = posArgCount; i < mandatoryParameters.size(); ++i) {
                    if (i != posArgCount) {
                        sb.append(", ");
                    }
                    sb.append(((FtlParameter)mandatoryParameters.get(i)).getName());
                }
                holder.registerProblem(callElement, FreeMarkerBundle.message("undefined.mandatory.parameters", sb.toString()), new LocalQuickFix[0]);
                return;
            }
            FtlParameter[] formalParams = type.getParameters();
            if (!(posArgCount <= formalParams.length || formalParams.length != 0 && formalParams[formalParams.length - 1].isVararg())) {
                holder.registerProblem(callElement, FreeMarkerBundle.message("too.many.parameters", new Object[0]), new LocalQuickFix[0]);
                return;
            }
            for (int i = 0; !(i >= Math.min(formalParams.length, posArgCount) || formalParams[i] instanceof FtlParameterDeclaration && formalParams[i].isVararg()); ++i) {
                FtlPsiType formalType = FtlPsiUtil.asInstanceOf(formalParams[i].getType(), FtlPsiType.class);
                FtlPsiType actualType = FtlPsiUtil.asInstanceOf(positionalArguments[i].getType(), FtlPsiType.class);
                if (formalType == null || actualType == null || formalType.getPsiType().isAssignableFrom(actualType.getPsiType())) continue;
                holder.registerProblem((PsiElement)positionalArguments[i], FreeMarkerBundle.message("type.mismatch", formalType.getPresentableText(), actualType.getPresentableText()), new LocalQuickFix[0]);
            }
            return;
        }
        THashSet mandatoryParams = new THashSet();
        for (FtlVariable variable : mandatoryParameters) {
            ContainerUtil.addIfNotNull((Object)variable.getName(), (Collection)mandatoryParams);
        }
        for (FtlNameValuePair argument : argumentList.getNamedArguments()) {
            String s = argument.getName();
            if (s == null) continue;
            mandatoryParams.remove(s);
        }
        if (!mandatoryParams.isEmpty()) {
            holder.registerProblem(callElement, FreeMarkerBundle.message("undefined.mandatory.parameters", StringUtil.join((Collection)mandatoryParams, (String)", ")), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlCallsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlCallsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.calls.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlCallsInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlCallsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlCallsInspection", "getShortName"));
        }
        return "FtlCallsInspection";
    }
}

