/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlFileReferencesInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlFileReferencesInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof FtlStringLiteral) {
                    ArrayList<FileReference> fileRefs = new ArrayList<FileReference>();
                    for (PsiReference reference : element.getReferences()) {
                        if (reference instanceof FtlFileReferenceDirective.FtlCustomFileReference && reference.resolve() != null) {
                            return;
                        }
                        if (!(reference instanceof FileReference)) continue;
                        fileRefs.add((FileReference)reference);
                    }
                    if (!fileRefs.isEmpty()) {
                        boolean resolvesCorrectly = true;
                        PsiDirectory parent = null;
                        ResolveResult[] results = ((FileReference)fileRefs.get(fileRefs.size() - 1)).multiResolve(false);
                        for (ResolveResult result : results) {
                            PsiElement psiElement = result.getElement();
                            if (psiElement instanceof FtlFile) {
                                PsiDirectory currentParent = ((PsiFile)psiElement).getContainingDirectory();
                                if (parent == null) {
                                    parent = currentParent;
                                    continue;
                                }
                                if (parent.equals(currentParent)) continue;
                                resolvesCorrectly = false;
                                break;
                            }
                            resolvesCorrectly = false;
                            break;
                        }
                        if (!resolvesCorrectly || parent == null) {
                            for (FileReference reference : fileRefs) {
                                if (reference.resolve() != null) continue;
                                holder.registerProblem((PsiReference)reference);
                                return;
                            }
                        }
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlFileReferencesInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlFileReferencesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlFileReferencesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.file.references.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlFileReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlFileReferencesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlFileReferencesInspection", "getShortName"));
        }
        return "FtlFileReferencesInspection";
    }
}

