/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlDeclarationCache;
import com.intellij.freemarker.psi.directives.FtlDeclarationHolder;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.ResolveStateParameters;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlIfDirective
extends FtlDirective {
    public static final Key<Boolean> MAYBE_UNDEFINED = Key.create((String)"mayBeUndefined");
    private static final Condition<FtlDirective> BRANCH_CONDITION = ftlDirective -> FtlIfDirective.isBranch((PsiElement)ftlDirective);
    private static final TObjectHashingStrategy<FtlAssignmentDeclaration> BY_NAME_STRATEGY = new TObjectHashingStrategy<FtlAssignmentDeclaration>(){

        public int computeHashCode(FtlAssignmentDeclaration object) {
            return object.getName().hashCode();
        }

        public boolean equals(FtlAssignmentDeclaration o1, FtlAssignmentDeclaration o2) {
            return o1.getName().equals(o2.getName());
        }
    };
    private final FtlDeclarationCache<FtlIfDirective> myDeclarationCache = new FtlDeclarationCache<FtlIfDirective>(this){

        @Override
        protected FtlDeclarationHolder calcDeclarationHolder(ResolveStateParameters parameters) {
            return FtlIfDirective.this.calcDeclarationHolder(parameters);
        }
    };

    public FtlIfDirective(ASTNode node) {
        super(node);
    }

    @Nullable
    public FtlExpression getCondition() {
        return (FtlExpression)this.findChildByClass(FtlExpression.class);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/directives/FtlIfDirective", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlIfDirective", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/directives/FtlIfDirective", "processDeclarations"));
        }
        if (FtlIfDirective.isBranch(lastParent)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        if (lastParent != null) {
            return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
        }
        return this.myDeclarationCache.processDirectiveDeclarations(processor, state, honorAssigns);
    }

    private FtlDeclarationHolder calcDeclarationHolder(ResolveStateParameters parameters) {
        List<FtlDirective> branches = this.getBranches();
        final ArrayList normalDeclarations = ContainerUtil.newArrayList();
        THashMap map = new THashMap(BY_NAME_STRATEGY);
        final TIntHashSet successfulBranches = new TIntHashSet();
        ResolveState state = parameters.createState();
        class BranchProcessor
        extends BaseScopeProcessor {
            final int branchIndex;
            final /* synthetic */ Map val$map;
            final /* synthetic */ List val$normalDeclarations;

            BranchProcessor(int branchIndex) {
                this.val$map = map;
                this.val$normalDeclarations = list;
                this.branchIndex = branchIndex;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlIfDirective$1BranchProcessor", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlIfDirective$1BranchProcessor", "execute"));
                }
                if (element instanceof FtlAssignmentDeclaration) {
                    FtlAssignmentDeclaration assignmentDeclaration = (FtlAssignmentDeclaration)element;
                    TIntHashSet intSet = (TIntHashSet)this.val$map.get(assignmentDeclaration);
                    if (intSet == null) {
                        intSet = new TIntHashSet();
                        this.val$map.put(assignmentDeclaration, intSet);
                    }
                    intSet.add(this.branchIndex);
                } else {
                    this.val$normalDeclarations.add(Pair.create((Object)element, (Object)state));
                }
                return true;
            }
        }
        if (super.processDirectiveDeclarations((PsiScopeProcessor)new BranchProcessor(0), state, null, parameters.honorAssigns)) {
            successfulBranches.add(0);
        }
        for (int i = 0; i < branches.size(); ++i) {
            if (!branches.get(i).processDirectiveDeclarations((PsiScopeProcessor)new BranchProcessor(i + 1), state, null, parameters.honorAssigns)) continue;
            successfulBranches.add(i + 1);
        }
        final boolean hasElseBranch = !branches.isEmpty() && FtlDirectiveType.isDirective((PsiElement)branches.get(branches.size() - 1), "else");
        final HashMap assignmentsUndefined = ContainerUtil.newHashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            FtlAssignmentDeclaration declaration;
            TIntHashSet branchesWithDefinition = (TIntHashSet)map.get(declaration = (FtlAssignmentDeclaration)iterator.next());
            boolean definedEverywhere = branchesWithDefinition.containsAll(successfulBranches.toArray());
            assignmentsUndefined.put(declaration, !definedEverywhere);
        }
        return new FtlDeclarationHolder(){

            @Override
            public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state) {
                if (!normalDeclarations.isEmpty()) {
                    for (Pair pair : normalDeclarations) {
                        if (processor.execute((PsiElement)pair.first, (ResolveState)pair.second)) continue;
                        return false;
                    }
                }
                for (Map.Entry entry : assignmentsUndefined.entrySet()) {
                    if (processor.execute((PsiElement)entry.getKey(), (Boolean)entry.getValue() != false ? state.put(MAYBE_UNDEFINED, (Object)Boolean.TRUE) : state)) continue;
                    return false;
                }
                return !hasElseBranch || !successfulBranches.isEmpty();
            }
        };
    }

    public static boolean isBranch(PsiElement lastParent) {
        return FtlDirectiveType.isDirective(lastParent, "else", "elseIf");
    }

    public List<FtlDirective> getBranches() {
        return ContainerUtil.findAll((Object[])this.getSubDirectives(), BRANCH_CONDITION);
    }
}

