/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlNestedDirective;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureCallableType;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCallableVariable;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlSpecialVariableType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlSignatureDirective
extends FtlDirective
implements FtlCallableVariable {
    private final NotNullLazyValue<CachedValue<Map<Integer, FtlType>>> myLoopVarsTypes;
    private final FtlLightVariable myLocalsVariable;

    public FtlSignatureDirective(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "<init>"));
        }
        super(node);
        this.myLocalsVariable = new FtlLightVariable(".locals", (PsiElement)this, new FtlSpecialVariableType(){

            @Override
            public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/directives/FtlSignatureDirective$1", "processDeclarations"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/directives/FtlSignatureDirective$1", "processDeclarations"));
                }
                return PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new BaseScopeProcessor(){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlSignatureDirective$1$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlSignatureDirective$1$1", "execute"));
                        }
                        return !(element instanceof FtlParameterDeclaration) && !(element instanceof FtlAssignmentDeclaration) || processor.execute(element, state);
                    }
                }, (PsiElement)place, (PsiElement)PsiTreeUtil.getParentOfType((PsiElement)place, FtlSignatureDirective.class), (ResolveState)FtlAssignmentType.allowAssignments(state, FtlAssignmentType.LOCAL));
            }
        });
        this.myLoopVarsTypes = new NotNullLazyValue<CachedValue<Map<Integer, FtlType>>>(){

            @NotNull
            protected CachedValue<Map<Integer, FtlType>> compute() {
                CachedValue cachedValue = CachedValuesManager.getManager((Project)FtlSignatureDirective.this.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<Integer, FtlType>>(){

                    public CachedValueProvider.Result<Map<Integer, FtlType>> compute() {
                        THashMap result = new THashMap();
                        FtlSignatureDirective.this.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Map)result){
                            final /* synthetic */ Map val$result;
                            {
                                this.val$result = map;
                            }

                            public void visitElement(PsiElement element) {
                                if (!(element instanceof FtlXmlTag)) {
                                    return;
                                }
                                if (element instanceof FtlNestedDirective) {
                                    FtlNestedDirective directive = (FtlNestedDirective)element;
                                    FtlExpression[] expressions = directive.getExpressions();
                                    for (int i = 0; i < expressions.length; ++i) {
                                        FtlType type;
                                        FtlType newType = expressions[i].getType();
                                        if (Comparing.equal((Object)newType, (Object)(type = (FtlType)this.val$result.get(i)))) {
                                            return;
                                        }
                                        if ((type = FtlPsiUtil.mergeTypes(newType, type)) == null) continue;
                                        this.val$result.put(i, type);
                                    }
                                }
                                super.visitElement(element);
                            }
                        });
                        return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                }, false);
                if (cachedValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlSignatureDirective$2", "compute"));
                }
                return cachedValue;
            }
        };
    }

    public Map<Integer, FtlType> getLoopVariableTypes() {
        return (Map)((CachedValue)this.myLoopVarsTypes.getValue()).getValue();
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public FtlParameterDeclaration findParameter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "findParameter"));
        }
        for (FtlParameterDeclaration declaration : this.getParameters()) {
            if (!name.equals(declaration.getName())) continue;
            return declaration;
        }
        return null;
    }

    public int getTextOffset() {
        PsiElement element = this.getNameElement();
        if (element != null) {
            return element.getTextRange().getStartOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PsiElement getNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "processDeclarations"));
        }
        if (lastParent != null && !processor.execute((PsiElement)this, state)) {
            return false;
        }
        if (FtlAssignmentType.isAssignmentAllowed(state, FtlAssignmentType.LOCAL)) {
            FtlParameterDeclaration[] parameters = this.getParameters();
            int end = lastParent instanceof FtlParameterDeclaration ? Arrays.asList(parameters).indexOf(lastParent) : parameters.length;
            for (int i = 0; i < end; ++i) {
                if (processor.execute((PsiElement)parameters[i], state)) continue;
                return false;
            }
        }
        return this.processDirectiveDeclarations(processor, state, lastParent, lastParent == null);
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        if (lastParent == null) {
            return true;
        }
        return processor.execute((PsiElement)this.myLocalsVariable, state) && this.processDeclarationsInside(processor, state, lastParent, honorAssigns);
    }

    public boolean processDeclarationsInside(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        Boolean result = (Boolean)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> FtlSignatureDirective.super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns));
        return result == null || result != false;
    }

    public FtlParameterDeclaration[] getParameters() {
        return (FtlParameterDeclaration[])this.findChildrenByClass(FtlParameterDeclaration.class);
    }

    @Nullable
    public String getName() {
        PsiElement node = this.getNameElement();
        return node == null ? null : node.getText();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlSignatureDirective", "setName"));
        }
        PsiElement element = FtlPsiUtil.parseFtlExpression(name, this.getProject());
        this.getNode().replaceChild(this.getNameElement().getNode(), element.getNode().getFirstChildNode());
        return this;
    }

    @Override
    public String getPresentableName() {
        return StringUtil.notNullize((String)this.getName());
    }

    public boolean isFunction() {
        return "function".equals(this.getDirectiveName());
    }

    @Override
    public FtlCallableType getType() {
        return new FtlSignatureCallableType(this);
    }
}

